/* -*- c++ -*-  (Tell emacs for this file to be cpp-header.)*/
#ifndef ELEMENT_H__
#define ELEMENT_H__

/**
 * @file element.h
 * Document class declarations generated by osixaka.
 */

#include <akaxiso/akaxiso.h>
#include <list>
#include <string>

void instantiate_xiso();

struct member {
  std::string name_;
  std::string title_;
};

typedef std::vector<member> members_type;

struct members {
  members_type members_;
};

struct project {
  std::string project_name_;
  std::string url_;
  members members_;
};

/** serialize as <member> */
void serialize(const member& root, std::ostream &ostm);
/** serialize as <members> */
void serialize(const members& root, std::ostream &ostm);
/** serialize as <project> */
void serialize(const project& root, std::ostream &ostm);
/** serialization of xs:string as :
     <project_name>,
     <url>.
*/
void serialize(const std::string& root, std::ostream &ostm, const std::string &docname);

#endif //ELEMENT_H__
