/* -*- c++ -*- */
#ifndef OSIXAKA2_AKAXISONIZER_H__
#define OSIXAKA2_AKAXISONIZER_H__

#include <osixaka2/processor.h>

namespace osx {

  class akaxisonizer {
    registry &registry_;
    registry_unit &regunit_;
    std::ostream &ostm_;
    bool verbose_;

    void dereference_user_classes(user_classes &uss);
    void dereference_elements(element_defs &edefs);

    void add_missings_for_classes(user_classes &uss);
    void add_missings_for_class(user_class &def);

    bool optimize_classes(user_classes &uss);
    bool simplify_class(user_class &def);
    bool simplify_children(user_class &def);
    bool simplify_one_element_type(user_class &def);

    bool add_member_number(aka::qname &name, const std::string &prefix, int index);
    void fix_anonymous_member_name(aka::qname &name);
    void fix_member_name(user_class &def);
    void rename_duplicate_member(user_class &def);
    bool array_required(const element_type &etype) const;
    bool array_required(const user_class &def) const;

    bool is_ptrmember(const element_type &etype) const;
    bool is_array(const element_type &etype) const;
    bool occ_required(const aka::occurrence &occ) const;

    void set_array_properties(const user_class &def, element_type &etype);
    bool replace_any(element_type &etype);
    bool replace_any(const type_ref &type, element_type &etype);
    bool replace_builtin(element_type &etype);
    void akaxisonize_particles(user_classes &uss);

    type_ref get_array(const type_ref &valuename);
    void create_arrays(user_classes &uss, user_classes &arrays);

    static std::string get_type_string(const std::string &tag,
				       const user_class &us);

  public:
    akaxisonizer(registry &reg, registry_unit &regunit, 
		 std::ostream &ostm, bool verbose)
      : registry_(reg), regunit_(regunit), ostm_(ostm), verbose_(verbose){}
    void add_missings();
    void check_names();
    void dereference();
    void optimize(); 
    void akaxisonize();
  };
}

#endif
