/* -*- c++ -*- */
#ifndef OSIXAKA2_CPP_NAMER_H__
#define OSIXAKA2_CPP_NAMER_H__

#include <osixaka2/osx.h>
#include <osixaka2/registry.h>

namespace osx {

  class cpp_namer {
    // accessors.
    const registry &registry_;
    const preference &pref_;

    std::string cppname(const aka::qname &name) const;
    std::string cpptype(const aka::qname &name) const;
    aka::qname rename(const type_ref &type) const;
  public:
    cpp_namer(const registry& reg) 
      : registry_(reg), pref_(reg.get_preference()) { }

    // For generators.
    aka::qname get_array_type(const aka::qname &name) const;
    void get_predefined_types(qname_set &resolved) const;
    std::string resolve_typedef(const type_ref &type);

    std::string classtype(const type_ref &type) const;
    std::string classname(const type_ref &type) const;

    std::string leafname(const type_ref &type) const;
    std::string leaftype(const type_ref &type) const;

    const std::string &choice_container_type() const;
    const std::string &array_container_type() const;
    const std::string &simplecontent_value_name() const;
    const std::string &get_member_prefix() const;
    const std::string &get_member_suffix() const;
    const std::string &get_array_prefix() const;
    const std::string &get_array_suffix() const;

    const aka::qname &get_classname() const;

    std::string escape(const std::string &to_escape) const;
  };
}

#endif

