#include "imported_types.h"


using namespace osx;

imported_type *imported_type_registry::add(import_id id, const aka::qname &name) {
  imports_.push_back(imported_type(id, name));
  return &imports_.back();
}

const imported_type *imported_type_registry::find_builtin(const aka::qname &name) const {
  for (imported_types::const_iterator it = builtins_.begin(); it != builtins_.end(); ++it) {
    if (it->name_ == name)
      return &*it;
  }
  return 0;
}

const imported_type *imported_type_registry::find_import(const aka::qname &name) const {
  for (imported_types::const_iterator it = imports_.begin(); it != imports_.end(); ++it) {
    if (it->name_ == name)
      return &*it;
  }
  return 0;
}

const imported_type* imported_type_registry::resolve(const aka::qname &name) const {

  const imported_type *imported = find_import(name);
  if (imported == 0)
    imported = find_builtin(name);
  
  if (imported == 0)
    return 0;

  switch (imported->import_id_) {
  case import_intrinsic:
  case import_user:
  case import_array:
    return imported;
  case import_resolve:
    return resolve(imported->resolve_);
  case import_na:
    break;
  }
  assert(!"Must not reach here.");
  return 0;
}


bool imported_type_registry::exists(const aka::qname &name) const {
  for (imported_types::const_iterator it = imports_.begin();
       it != imports_.end(); ++it) {
    if (it->name_ == name)
      return true;
  }
  return false;
}

void imported_type_registry::set_preference(const preference &pref) {

  const osx::internal &internal = *pref.internal_;

  const osx::type_array &builtins = internal.builtins_.type_;
  for (osx::type_array::const_iterator bit = builtins.begin();
       bit != builtins.end(); ++bit) {
    add_pref_type(*bit, import_intrinsic, builtins_);
  }

  const osx::imports_choice &ts = internal.imports_.c0_;
  for (imports_choice::const_iterator it = ts.begin();
       it != ts.end(); ++it) {
    const aka::item &item = *it;
    if (aka::item_of(item, "osx:resolve")) {
      const osx::resolve &resolve = aka::item_cast<osx::resolve>(item);
      imported_type imported(import_resolve, aka::qname(resolve.name_));
      imported.resolve_ = aka::qname(resolve.value_);
      imports_.push_back(imported);
    }
    else if (aka::item_of(item, "osx:type")) {
      const osx::type &type = aka::item_cast<osx::type>(item);
      add_pref_type(type, import_user, imports_);
    }
    else {
      assert(!"Must not reach here.");
    }
  }
}

void imported_type_registry::add_pref_type(const osx::type &type, 
					       import_id id,
					       imported_types &types) {

  imported_type imported(id, aka::qname(type.name_));

  const xs::token *leaf = type.primitive_.leaf_.get();
  const xs::token *typedefname = type.primitive_.typedef_.get();
  const osx::builtin_array *array = type.array_.get();

  if (leaf != 0)
    imported.leaf_ = *leaf;
  if (typedefname != 0)
    imported.typedef_ = *typedefname;
  if (array != 0)
    imported.array_name_ = aka::qname(array->name_);

  types.push_back(imported);

  // construct array type.
  if (array != 0) {
    imported_type imported_array(import_array, aka::qname(array->name_));
    leaf = array->primitive_.leaf_.get();
    if (leaf != 0)
      imported_array.leaf_ = *leaf;
    typedefname = array->primitive_.typedef_.get();
    if (typedefname != 0)
      imported_array.typedef_ = *typedefname;
    
    types.push_back(imported_array);
    
  }

}
