/* -*- c++ -*- */
#ifndef OSIXAKA2_IMPORTED_TYPES_H__
#define OSIXAKA2_IMPORTED_TYPES_H__

#include <akaxiso2/akaxiso2.h>
#include <osixaka2/osx.h>
#include <osixaka2/userdefs.h>

namespace osx {
  
  enum import_id {
    import_na,
    import_intrinsic,
    import_user,
    import_resolve,
    import_array
  };

  class imported_type {
    friend class imported_type_registry;
    imported_type() : import_id_(import_na) {}
    imported_type(import_id id, const aka::qname &name) 
      : import_id_(id), name_(name) {}
  public:
    import_id import_id_;
    aka::qname name_;
    std::string leaf_;
    std::string typedef_;

    // type-dependent members.
    aka::qname resolve_; // imported_resolve: resolve distination.
    aka::qname array_name_; //imported_intrinsic: array name corresponding to simpleType. 
  };

  typedef std::vector<imported_type> imported_types;
  class imported_type_registry {
    imported_types builtins_;
    imported_types imports_;
    void add_pref_type(const osx::type &type, import_id id, imported_types &types);
  public:
    imported_type *add(import_id id, const aka::qname &name);
    const imported_type *find_builtin(const aka::qname &name) const;
    const imported_type *find_import(const aka::qname &name) const;
    const imported_type *resolve(const aka::qname &name) const;
    bool exists(const aka::qname &name) const;
    void set_preference(const preference &pref);
    void add_system_imports();
  };

}

#endif
