/* -*- c++ -*- */
#ifndef osx_xiso_h__
#define osx_xiso_h__

#include <osixaka2/osx.h>

#include <akaxiso2/content_model.h>


namespace osx {

  struct array_type_leaf : aka::sequence< ::osx::array_type, array_type_leaf> {
    void model();
  };

  typedef aka::sequential_array< ::osx::array_type_array, ::osx::array_type_leaf > array_type_array_leaf;

  struct primitive_leaf : aka::all< ::osx::primitive, primitive_leaf> {
    void model();
  };

  struct builtin_array_leaf : aka::sequence< ::osx::builtin_array, builtin_array_leaf> {
    void model();
  };

  typedef aka::sequential_array< ::osx::builtin_array_array, ::osx::builtin_array_leaf > builtin_array_array_leaf;

  struct type_leaf : aka::sequence< ::osx::type, type_leaf> {
    void model();
  };

  typedef aka::sequential_array< ::osx::type_array, ::osx::type_leaf > type_array_leaf;

  struct builtins_leaf : aka::sequence< ::osx::builtins, builtins_leaf> {
    void model();
  };

  typedef aka::sequential_array< ::osx::builtins_array, ::osx::builtins_leaf > builtins_array_leaf;

  struct container_type_leaf : aka::sequence< ::osx::container_type, container_type_leaf> {
    void model();
  };

  typedef aka::sequential_array< ::osx::container_type_array, ::osx::container_type_leaf > container_type_array_leaf;

  struct include_leaf : aka::simplecontent< ::osx::include, include_leaf> {
    void model();
  };

  struct namespace_leaf : aka::sequence< ::osx::_namespace, namespace_leaf> {
    void model();
  };

  struct directives_choice_leaf : aka::sequential_choice< ::osx::directives_choice, directives_choice_leaf> {
    void model();
  };

  struct directives_leaf : aka::sequence< ::osx::directives, directives_leaf> {
    void model();
  };

  typedef aka::sequential_array< ::osx::directives_array, ::osx::directives_leaf > directives_array_leaf;

  struct escape_leaf : aka::sequence< ::osx::escape, escape_leaf> {
    void model();
  };

  typedef aka::sequential_array< ::osx::escape_array, ::osx::escape_leaf > escape_array_leaf;

  struct escapes_leaf : aka::sequence< ::osx::escapes, escapes_leaf> {
    void model();
  };

  typedef aka::sequential_array< ::osx::escapes_array, ::osx::escapes_leaf > escapes_array_leaf;

  struct member_type_leaf : aka::sequence< ::osx::member_type, member_type_leaf> {
    void model();
  };

  struct simplecontent_value_name_leaf : aka::sequence< ::osx::simplecontent_value_name, simplecontent_value_name_leaf> {
    void model();
  };

  struct format_leaf : aka::sequence< ::osx::format, format_leaf> {
    void model();
  };

  typedef aka::sequential_array< ::osx::format_array, ::osx::format_leaf > format_array_leaf;

  struct resolve_leaf : aka::simplecontent< ::osx::resolve, resolve_leaf> {
    void model();
  };

  struct imports_choice_leaf : aka::sequential_choice< ::osx::imports_choice, imports_choice_leaf> {
    void model();
  };

  struct imports_leaf : aka::sequence< ::osx::imports, imports_leaf> {
    void model();
  };

  typedef aka::sequential_array< ::osx::imports_array, ::osx::imports_leaf > imports_array_leaf;

  typedef aka::sequential_array< ::osx::include_array, ::osx::include_leaf > include_array_leaf;

  struct internal_leaf : aka::all< ::osx::internal, internal_leaf> {
    void model();
  };

  typedef aka::sequential_array< ::osx::internal_array, ::osx::internal_leaf > internal_array_leaf;

  typedef aka::sequential_array< ::osx::member_type_array, ::osx::member_type_leaf > member_type_array_leaf;

  struct substitution_leaf : aka::sequence< ::osx::substitution, substitution_leaf> {
    void model();
  };

  typedef aka::sequential_array< ::osx::substitution_array, ::osx::substitution_leaf > substitution_array_leaf;

  struct substitutions_leaf : aka::sequence< ::osx::substitutions, substitutions_leaf> {
    void model();
  };

  struct preference_leaf : aka::sequence< ::osx::preference, preference_leaf> {
    void model();
  };

  typedef aka::sequential_array< ::osx::preference_array, ::osx::preference_leaf > preference_array_leaf;

  typedef aka::sequential_array< ::osx::resolve_array, ::osx::resolve_leaf > resolve_array_leaf;

  typedef aka::sequential_array< ::osx::simplecontent_value_name_array, ::osx::simplecontent_value_name_leaf > simplecontent_value_name_array_leaf;

  typedef aka::sequential_array< ::osx::substitutions_array, ::osx::substitutions_leaf > substitutions_array_leaf;

  typedef aka::sequential_array< ::osx::primitive_array, ::osx::primitive_leaf > primitive_array_leaf;


}

#endif // #ifndef osx_xiso_h__
