/* -*- c++ -*- */
#ifndef OSIXAKA2_PREPROCESSOR_H__
#define OSIXAKA2_PREPROCESSOR_H__

#include <osixaka2/registry.h>
#include <osixaka2/XMLSchema.h>
#include <osixaka2/osx.h>

namespace osx {

  class preprocessor {
    xs::schema *deserialize(const std::string &filename);
    void process_include(const xs::include &include);
    void process_import(const xs::import &import);
    void process_redefine(const xs::redefine &redefine);
    void process_annotation(const xs::annotation &ann);
    void process_osx_element(const aka::any &any);
    static void merge_schema(xs::schema &schema, const xs::schema &to_merge);
    // For preprocessor.
    bool is_processed(const std::string &simplified_path) const;
    bool preprocess_recursive(const std::string &filename);

    registry &registry_;
    std::string basepath_;
    bool generate_deps_;
    aka::id_type target_ns_id_;
    std::ostream &ostm_;
    bool verbose_;
    registry_unit unit_;
  public:
    preprocessor(registry &reg, 
		 bool generate_deps,
		 std::ostream &ostm, bool verbose) 
      : registry_(reg), 
	generate_deps_(generate_deps),
	ostm_(ostm), verbose_(verbose) { }
  
    void preprocess(const std::string &filename);
    aka::id_type get_target_ns_id() const { return target_ns_id_; }
    const registry_unit &get_unit() const;
  };

}

#endif
