/* -*- c++ -*- */
#ifndef OSIXAKA2_REGISTRY_H__
#define OSIXAKA2_REGISTRY_H__

#include <akaxiso2/akaxiso2.h>
#include <osixaka2/userdefs.h>
#include <osixaka2/registry_unit.h>
#include <osixaka2/osx.h>

namespace osx {

  typedef std::vector<registry_unit*> units;
  typedef std::vector<const registry_unit*> const_units;

  class registry {
    typedef std::vector<registry_unit> registry_units;
    const preference *pref_;
    const registry_unit *find_unit_by_type(const type_ref &type) const;
    registry_units units_;
    registry(const registry&);// hidden copy-ctor.
  public:
    registry();
    void set_preference(const preference &pref);
    const preference &get_preference() const { return *pref_; }
    registry_unit &operator[](const aka::id_type target_ns_id); 
    const registry_unit &get_imported_unit() const { return units_.front(); }

    units get_units();
    const_units get_units() const;
    void add_unit(const registry_unit &unit);

    // For processor/akaxisonizer.
    bool erasable(const type_ref &type) const;

    // is builtin type (excluding xs:anyType, xs:any).
    import_id get_import_id(const aka::qname &type) const;

    bool type_exists(const type_ref &type) const;

    // imported types.
    const imported_type *get_imported_type(const aka::qname &name) const;
    // name declaration types.
    const gattribute_def *globalAttribute_get(const aka::qname &name) const;
    const attributeGroup_def *attributeGroup_get(const aka::qname &name) const;
    // user-defined classes (to generate.)
    user_class *complexType_get(const aka::qname &type);
    user_class *group_get(const aka::qname &type);
    const user_class *simpleType_get(const aka::qname &type) const;
    element_def *element_get(const aka::qname &type);

    // imported type resolver
    const imported_type *resolve_imported_type(const imported_type *entry) const;
    type_ref resolve_type(const type_ref &type) const;
    type_ref resolve_typedef(const type_ref &type) const;

    // is "xs:anyType" or "xs:anySimpleType"?
    bool is_xs_any(const aka::qname &type) const;
    // is "aka::any", or "aka::any_array"
    bool is_aka_any(const aka::qname &type) const;

    // For akaxisonizer.
    const imported_type *get_imported_array_type(const imported_type *imported) const;
    const user_class *find_array_type(const user_class *us) const;

    type_ref resolve_type_ref(const type_ref &type);

    // for processor.
    type_ref get_anySimpleType() const;
    type_ref get_anyType() const;

    /* builtin types */
    type_ref get_std_string() const;
    type_ref get_std_string_array() const;
    type_ref get_aka_wildcard() const;
    /* imported types */
    type_ref get_nill_type() const;
    type_ref get_aka_any() const;
    type_ref get_aka_any_array() const;

    aka::qname create_array_type_name(const aka::qname &name) const;
    aka::qname create_particle_item_name(const aka::qname &name) const;
    type_ref create_array(const type_ref &value_type, user_classes &arrays);
  };

}
#endif
