#include "registry_unit.h"

using namespace osx;

registry_unit::registry_unit() 
  : target_ns_id_(aka::empty_token) { }

registry_unit::registry_unit(xs::schema *schema, aka::id_type target_ns_id, 
			     const std::string &basename, const std::string &filename) 
  : schema_(schema), target_ns_id_(target_ns_id), 
    basename_(basename), filename_(filename) { }

bool registry_unit::type_exists(const type_ref &type) const {
  const aka::qname &name = type.get_name();
  if (imports_.find_import(name) != 0)
    return true;
  if (complexTypes_.exists(name))
    return true;
  if (simpleTypes_.exists(name))
    return true;
  if (groups_.exists(name))
    return true;
  if (local_complexTypes_.exists(name))
    return true;
  if (local_simpleTypes_.exists(name))
    return true;
  if (local_classes_.exists(name))
    return true;
  return false;
}

user_class* registry_unit::user_class_get(const type_ref &type) {
  assert(!type.empty());
  if (type.us_ != 0)
    return 0;

  const aka::qname &name = type.get_name();
  if (complexTypes_.exists(name))
    return complexTypes_.get(name);
  if (simpleTypes_.exists(name))
    return simpleTypes_.get(name);
  if (groups_.exists(name))
    return groups_.get(name);
  if (local_complexTypes_.exists(name))
    return local_complexTypes_.get(name);
  if (local_simpleTypes_.exists(name))
    return local_simpleTypes_.get(name);
  if (local_classes_.exists(name))
    return local_classes_.get(name);
  return 0;
}

bool registry_unit::erasable(const type_ref &type) const {
  if (local_classes_.exists(type.get_name()))
    return true;
  if (local_complexTypes_.exists(type.get_name()))
    return true;
  if (type.us_ != 0)
    return  (type.us_->id_ == array_id);
  return false;
}

void registry_unit::set_preference(const preference &pref) {
  
  const osx::directives_choice &dirs = pref.directives_.c0_;
  for (osx::directives_choice::const_iterator it = dirs.begin();
       it != dirs.end(); ++it) {
    const aka::item &item = *it;
    if (aka::item_of(item, "osx:namespace")) {
      const osx::_namespace &ns = aka::item_cast<osx::_namespace>(item);
      aka::xmlns(ns.prefix_, ns.uri_);
    }
    else if (aka::item_of(item, "osx:include")) {
      const osx::include &include = aka::item_cast<osx::include>(item);
      includes_.push_back(include);
    }
    else if (aka::item_of(item, "osx:xiso_include")) {
      const osx::include &include = aka::item_cast<osx::include>(item);
      xiso_includes_.push_back(include);
    }
    else if (aka::item_of(item, "osx:ximpl_include")) {
      const osx::include &include = aka::item_cast<osx::include>(item);
      ximpl_includes_.push_back(include);
    }
    else {
      assert(!"Must not reach here.");
    }
  }
  imports_.set_preference(pref);
}
