/* -*- c++ -*- */
#ifndef OSIXAKA2_REGISTRY_UNIT_H__
#define OSIXAKA2_REGISTRY_UNIT_H__

#include <osixaka2/osx.h>
#include <osixaka2/imported_types.h>
#include <osixaka2/userdefs.h>

namespace xs {
  struct schema;
}

namespace osx {

  typedef std::vector<include> includes;
  typedef std::vector<_namespace> namespaces;

  class registry_unit {
  public:
    registry_unit();
    registry_unit(xs::schema *schema, aka::id_type target_ns_id, 
		  const std::string &basename, const std::string &filename);

    xs::schema *schema_;
    aka::id_type target_ns_id_;
    std::string basename_;
    std::string filename_;
    includes includes_;
    includes xiso_includes_;
    includes ximpl_includes_;
    namespaces namespaces_;

    attrGroup_defs attributeGroups_;
    gattribute_defs gattributes_;
    element_defs elements_;
    imported_type_registry imports_;
    user_classes simpleTypes_;
    user_classes complexTypes_;
    user_classes groups_;

    user_classes local_complexTypes_;
    user_classes local_simpleTypes_;

    user_classes local_classes_;

    bool type_exists(const type_ref &type) const;
    user_class *user_class_get(const type_ref &type);
    bool erasable(const type_ref &type) const;
    void set_preference(const preference &pref);
  };
}

#endif
