#include "userdefs.h"
#include "exception.h"
#include "imported_types.h"

#include <assert.h>


using namespace osx;

const aka::qname &type_ref::get_name() const {
  if (imported_ != 0)
    return imported_->name_;
  else if (us_ != 0)
    return us_->get_name();
  else if (!referred_name_.empty())
    return referred_name_;
  assert(!"Must not reach here.");
  return *static_cast<aka::qname*>(0);
}

const aka::qname &type_ref::get_classname() const {
  if (imported_ != 0)
    return imported_->name_;
  else if (us_ != 0)
    return us_->get_classname();
  assert(!"Must not reach here.");
  return *static_cast<aka::qname*>(0);
}


void attribute_defs::erase(const aka::qname &name) {
  for (attribute_types::iterator it = attributes_.begin();
       it != attributes_.end(); ++it) {
    if (it->name_ == name) {
      attributes_.erase(it);
      return;
    }
  }
  assert(!"Must not reach here.");
}

attribute_type *attribute_defs::get(const aka::qname &name) {
  for (attribute_types::iterator it = attributes_.begin();
       it != attributes_.end(); ++it) {
    if (it->name_ == name) {
      return &*it;
    }
  }
  return 0;
}


user_class user_class::derive(const aka::qname &name, const aka::qname &classname) const {
  assert(!name.empty());
  user_class def = *this;
  def.name_ = name;
  def.classname_ = classname;
  return def;
}


void user_class::check_dup_elements() const {
  qname_set names;
  for (element_types::const_iterator it = etypes_.begin();
       it != etypes_.end(); ++it) {
    if (names.find(it->name_) != names.end())
      raise_name_error("element", it->name_, "appeared more than once.", __FILE__, __LINE__);
    names.insert(it->name_);
  }
}

void user_class::check_dup_attributes() const {
  qname_set names;
  for (attribute_types::const_iterator it = adefs_.attributes_.begin();
       it != adefs_.attributes_.end(); ++it) {
    if (names.find(it->name_) != names.end())
      raise_name_error("attribute", it->name_, "appeared more than once.", __FILE__, __LINE__);
    names.insert(it->name_);
  }
}

const aka::qname &user_class::get_classname() const {
  if (!classname_.empty())
    return classname_;
  else
    return name_;
}
