/* -*- c++ -*- */
#include "osixaka2.h"
#include "ltg.h"

#include <iostream>
#include <iomanip>
#include <fstream>
#include <stdlib.h>

#include <sys/stat.h>
#include <sys/types.h>

bool test_parse_ok(const ltg::file &f) {
  osx::osixaka2 osi(std::cerr, false, false);
  std::string outputdir = f.get_outputpath("./generated");
  osi.set_outputdir(outputdir);
  mkdir(outputdir.c_str(), 0777);
  osi.load_defaults();
  osi.commit_preference();
  if (osi.preprocess(f.get_filepath(), true) != 0)
    return false;
  if (osi.process() != 0)
    return false;
  if (osi.akaxisonize(1) != 0)
    return false;
  return osi.generate(false) == 0;
}

bool test_parse_ng(const ltg::file &f) {
  std::ostringstream ostm;

  osx::osixaka2 osi(ostm, false, false);

  std::string outputdir = f.get_outputpath("./generated");
  osi.set_outputdir(outputdir);
  mkdir(outputdir.c_str(), 0777);

  osi.load_defaults();
  osi.commit_preference();
  if (osi.preprocess(f.get_filepath(), true) != 0)
    return true;
  if (osi.process() != 0)
    return true;
  if (osi.akaxisonize(1) != 0)
    return true;
  return osi.generate(false) != 0;
}


int main(int argc, char* argv[]){

  mkdir("./generated", 0777);

  aka::initialize();
  // Initialize XML-Schema Document Classes.
  ltg::instantiate_xiso();
  osx::osixaka2::initialize();

  int total = 0;
  int ok = 0;

  aka::document ltgdoc = aka::deserialize_file(argv[1]);
  ltg::root *root = aka::root_cast<ltg::root>(ltgdoc);
  const ltg::tests &tests = root->tests_;

  for (ltg::tests::const_iterator testit = tests.begin();
       testit != tests.end(); ++testit) {
    const ltg::files &fs = testit->files_;
    for (ltg::files::const_iterator fileit = fs.begin();
	 fileit != fs.end(); ++fileit) {
      bool res;
      bool done = false;

      if (fileit->validity_ && (fileit->role_ == "schema")) {
	res = test_parse_ok(*fileit);
	done = true;
      }
      else if (!fileit->validity_ && (fileit->role_ == "schema")) {
	res = test_parse_ng(*fileit);
	done = true;
      }

      if (done) {
	if (res) {
	  ++ok;
	  std::cout << '.' << std::flush;
	}
	else {
	  std::cout << std::endl
		    << "Failure:" << fileit->get_filepath() << std::endl;
	} 
	++total;
      }
    }
  }

  std::cout << std::endl
	    << argv[1] << std::endl
	    << "total: " << total 
	    << "  ok: " << ok << "  fail: " << total - ok << std::endl;

  // Uninitializers.
  aka::uninitialize();
  return 0;
}
