//CUPPA:include=+
//CUPPA:include=-
#include <cppunit/extensions/HelperMacros.h>
#include <cppunit/TestAssert.h>

//CUPPA:namespace=+
//CUPPA:namespace=-

#include <akaxiso2/akaxiso2.h>
#include <akaxiso2/content_model.h>

#include <iostream>

namespace {

  /** testing <xs:any> */

  struct any_test {
    std::string member1_;
    aka2::any any_;
    std::string member2_;
  };

  struct anyptr_test {
    std::string member1_;
    aka2::deep_ptr<aka2::any> any_;
    std::string member2_;
  };

  struct any_array_test {
    aka2::any_array array1_;
    std::string value_;
    aka2::any_array array2_;
  };

  struct anyType_test {
    std::string value1_;
    aka::any any_;
    std::string value2_;
    aka::any_array anys_;
    std::string value3_;
  };

  struct any_all_leaf : aka2::all<any_test, any_all_leaf> {
    void model() {
      member("member1", &any_test::member1_);
      any("any", &any_test::any_);
      member("member2", &any_test::member2_);
    }
  };

  struct anyptr_leaf : aka2::all<anyptr_test, anyptr_leaf> {
    void model() {
      member("member1", &anyptr_test::member1_);
      any_ptrmember("anyptr", &anyptr_test::any_);
      member("member2", &anyptr_test::member2_);
    }
  };
  
  struct any_array_all_leaf : aka2::all<any_array_test, any_array_all_leaf> {
    void model() {
      any("any1", &any_array_test::array1_, 0, 1);
      member("value", &any_array_test::value_);
      any("any2", &any_array_test::array2_, 0, 1);
    }
  };

  struct anyType_all_leaf : aka2::all<anyType_test, anyType_all_leaf> {
    void model() {
      member("value1", &anyType_test::value1_);
      any("any_node", &anyType_test::any_);
      member("value2", &anyType_test::value2_);
      any("any_node_array", &anyType_test::anys_, 0, 1);
      member("value3", &anyType_test::value3_);
    }
  };

}



class anyAllTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE(anyAllTest);
//CUPPA:suite=+
  CPPUNIT_TEST(test_serialize);
  CPPUNIT_TEST(test_deserialize);
  CPPUNIT_TEST(test_serialize_array);
  CPPUNIT_TEST(test_deserialize_array);
  CPPUNIT_TEST(test_anyType);
  CPPUNIT_TEST(test_anyType_error);
  CPPUNIT_TEST(test_anyptr);
  CPPUNIT_TEST(test_anyTypeArray_error);
//CUPPA:suite=-
  CPPUNIT_TEST_SUITE_END();
private:

  // your stuff...

public:

  virtual void setUp() {
    aka2::initialize();
    aka2::doctype("any_all", any_all_leaf());
    aka2::doctype("anyptr_all", anyptr_leaf());
    aka2::doctype("any_array_all", any_array_all_leaf()); 
    aka2::doctype("anyType_all", anyType_all_leaf());
  }

  virtual void tearDown() { 
    aka2::uninitialize();
  }

  any_test create_root() {
    any_test root;
    root.member1_ = "member1";
    root.member2_ = "member2";

    root.any_.wc_.name_ = aka2::qname("any_element");
    root.any_.wc_.value_ = "any's value.";

    root.any_.wc_.attributes_.push_back(aka2::wc_attribute(aka2::qname("test"), "value"));

    aka2::wildcard child;
    child.name_ = aka2::qname("child_node");
    root.any_.wc_.children_.push_back(child);

    return root;
  }

//CUPPA:decl=+
  void test_serialize() {
    any_test root = create_root();
    aka2::xml_serializer ser;
    std::ostringstream ostm;
    ser.serialize(root, "any_all", ostm);
//     std::cout << ostm.rdbuf()->str() << std::endl;
  }

  void test_serialize_array() {
    any_array_test root;
    root.value_ = "value";
    aka2::xml_serializer ser;
    std::ostringstream ostm;
    ser.serialize(root, "any_array_all", ostm);
    //std::cout << ostm.rdbuf()->str() << std::endl;
  }

  void test_deserialize() {
    any_test root = create_root();
    aka2::xml_serializer ser;
    std::ostringstream ostm;
    ser.serialize(root, "any_all", ostm);

    aka2::xml_deserializer deserializer;
    aka2::document doc = deserializer.deserialize(ostm.rdbuf()->str());
  }


  void test_anyptr() {
    const char *urdoc1 = 
      "<?xml version=\"1.0\"?>\n"
      "<anyptr_all>\n"
      "<member1>ss</member1>\n"
      "<anyptr fake_attr=\"attr\">test1<ur_node>test</ur_node></anyptr>\n"
      "<member2>ss</member2>\n"
      "</anyptr_all>\n";
    const char *urdoc2 = 
      "<?xml version=\"1.0\"?>\n"
      "<anyptr_all>\n"
      "<member1>ss</member1>\n"
//       "<anyptr fake_attr=\"attr\">test1<ur_node>test</ur_node></anyptr>\n"
      "<member2>ss</member2>\n"
      "</anyptr_all>\n";

    aka2::xml_deserializer deserializer;
    deserializer.deserialize(urdoc1);
    deserializer.deserialize(urdoc2);

//     aka2::xml_serializer ser;
//     ser.serialize(doc, std::cout);
  }


  void test_deserialize_array() {
    any_array_test root;

    aka2::any an;
    an.wc_.name_ = aka2::qname("test1");
    //root.array1_.push_back(an);
    //root.array1_.push_back(an);

    root.value_ = "value";

    an.wc_.name_ = aka2::qname("any2");
    root.array2_.push_back(an);
//     root.array2_.push_back(an); // validation error message is not enough. !!!!!!!!!!!!!

    aka2::xml_serializer ser;
    std::ostringstream ostm;
    ser.serialize(root, "any_array_all", ostm);
//     std::cout << ostm.rdbuf()->str() << std::endl;

    aka2::xml_deserializer deserializer;
    aka2::document doc = deserializer.deserialize(ostm.rdbuf()->str());

//     ser.serialize(doc, std::cout);
  }



  void test_anyType() {
    const char *urdoc = 
      "<?xml version=\"1.0\"?>\n"
      "<anyType_all>\n"
      "<value1>ss</value1>\n"
      "<any_node fake_attr=\"attr\">test1<ur_node>test</ur_node></any_node>\n"
      "<value2>ss</value2>\n"
      "<any_node_array fake_attr=\"attr\">test1<ur_node>test</ur_node></any_node_array>\n"
//        "<any_node_array fake_attr=\"attr\">test1<ur_node>test</ur_node></any_node_array>\n"
      "<value3>ss</value3>\n"
      "</anyType_all>\n";

    aka2::xml_deserializer deserializer;
    aka2::document doc = deserializer.deserialize(urdoc);

//     aka2::xml_serializer ser;
//     ser.serialize(doc, std::cout);
  }

  void test_anyType_error() {
    const char *urdoc = 
      "<?xml version=\"1.0\"?>\n"
      "<anyType_test>\n"
      "<value1>ss</value1>\n"
      "<any_node_wrong fake_attr=\"attr\">test1<ur_node>test</ur_node></any_node_wrong>\n"  // Wrong tagname
      "<value2>ss</value2>\n"
      "<any_node_array fake_attr=\"attr\">test1<ur_node>test</ur_node></any_node_array>\n"
      "<any_node_array fake_attr=\"attr\">test1<ur_node>test</ur_node></any_node_array>\n"
      "<value3>ss</value3>\n"
      "</anyType_test>\n";
    
    bool raised = false;
    try {
      aka2::xml_deserializer deserializer;
      aka2::document doc = deserializer.deserialize(urdoc);
      //     aka2::xml_serializer ser;
      //     ser.serialize(doc, std::cout);
    }
    catch (const std::exception &) {
      raised = true;
    }
    CPPUNIT_ASSERT_MESSAGE("ERROR", raised);
  }


  void test_anyTypeArray_error() {
    const char *urdoc = 
      "<?xml version=\"1.0\"?>\n"
      "<anyType_test>\n"
      "<value1>ss</value1>\n"
      "<any_node fake_attr=\"attr\">test1<ur_node>test</ur_node></any_node>\n"
      "<value2>ss</value2>\n"

      // Wrong tagname any_node_array -> any_node_array_wrong
      "<any_node_array_wrong fake_attr=\"attr\">test1<ur_node>test</ur_node></any_node_array_wrong>\n"
      "<any_node_array fake_attr=\"attr\">test1<ur_node>test</ur_node></any_node_array>\n"
      "<value3>ss</value3>\n"
      "</anyType_test>\n";
    
    bool raised = false;
    try {
      aka2::xml_deserializer deserializer;
      aka2::document doc = deserializer.deserialize(urdoc);
      //     aka2::xml_serializer ser;
      //     ser.serialize(doc, std::cout);
    }
    catch (const std::exception &) {
      raised = true;
    }
    CPPUNIT_ASSERT_MESSAGE("ERROR", raised);
  }

//CUPPA:decl=-
};

//CUPPA:impl=+
//CUPPA:impl=-

CPPUNIT_TEST_SUITE_REGISTRATION(anyAllTest);
