#include "wildcard_handler.h"
#include "../../framework/any_op.h"
#include "../../util/sstream.h"

#include <cassert>

using namespace aka2;

wildcard_handler::wildcard_handler(wildcard &wc, int depth,
				   const qname &tagname, const element_props &props,
				   parser_context &context)  
  : handler(false, depth, props, context) , wc_(wc), child_(0) {
  wc_.name_ = tagname;
}

wildcard_handler::~wildcard_handler() {
  abort();
}


validation_result wildcard_handler::query_element(const qname &tagname, const attribute_values &attrs){
  child_ = new wildcard;
  create_wildcard_handler(*child_, depth_ + 1, tagname, props_);
  return ok;
}

validation_result wildcard_handler::query_next(const qname &tagname, const attribute_values &attrs){
  assert(!"Must not be called.");
  return invalid;
}



validation_result wildcard_handler::end_element(const qname &tagname){
  if (!wc_.children_.empty())
    wc_.value_ == "";
  return ok;
}


bool wildcard_handler::parse_entity(const pstring &entity) {
  if (wc_.value_.empty())
    wc_.value_ = context_.to_lcp(entity);
  return true;
}


node wildcard_handler::get_node() {
  return node(&wc_, aka2::wildcard_op::dispatcher_);
}

void wildcard_handler::receive_child(const node &child) {
  wc_.children_.push_back(*child_);
  delete child_;
  child_ = 0;
}

bool wildcard_handler::can_skip() {
  return false;
}

void wildcard_handler::abort() {
  if (child_ != 0) {
    delete child_;
    child_ = 0;
  }
}

