/* -*- c++ -*- */
#ifndef AKAXISO2_XML_XERCES_XERCES_DESERIALIZER_H__
#define AKAXISO2_XML_XERCES_XERCES_DESERIALIZER_H__

/**
 * @file akaxiso2/XML/xerces/xerces_deserializer.h
 * @brief XML deserializer by using Xerces-C++ SAX2 parser.
 */

#include <akaxiso2/configuration.h>
#ifdef AKAXISO2_USE_XERCESC


#include <akaxiso2/XML/deserializer/deserializer.h>
#include <akaxiso2/XML/xerces/transcoding_inputsource.h>
#include <xercesc/sax2/SAX2XMLReader.hpp>

namespace aka2 {

  class xerces_handler;

  /**
   * @brief XML deserializer class by using Xerces-C++ SAX2 parser.
   */
  class xerces_deserializer : public deserializer {
    transcoder_factory trfact_;
    xercesc::SAX2XMLReader *parser_;
    entity_complements *ecomps_;
    document deserialize_internal(TranscodingInputSource &src, 
				  const std::string &source_name);
    void create_parser();

  public:
    xerces_deserializer(transcoder_factory trfact = 0);
    virtual ~xerces_deserializer();

    virtual document deserialize(std::istream &istm);
    virtual document deserialize(const char *doc);
    virtual document deserialize(const std::string &doc);
    virtual document deserialize_stdin();
    virtual document deserialize_file(const std::string &filename);
    virtual entity_complements &get_entity_complements();

    xercesc::SAX2XMLReader *get_parser();

  };

} // namespace aka2

#endif

#endif
