#include "schema_builtin_xiso.h"
#include "../content_model.h"
#include "validator.h"
#include "../framework/namespaces.h"
#include "../util/string_funcs.h"

namespace xs {
  
  void initialize_schema_builtins() {
    xs::int_leaf::initialize();
    xs::unsignedInt_leaf::initialize();
    xs::long_leaf::initialize();
    xs::unsignedLong_leaf::initialize();
    xs::short_leaf::initialize();
    xs::unsignedShort_leaf::initialize();
    xs::float_leaf::initialize();
    xs::double_leaf::initialize();
    xs::positiveInteger_leaf::initialize();
    xs::negativeInteger_leaf::initialize();
    xs::nonPositiveInteger_leaf::initialize();
    xs::nonNegativeInteger_leaf::initialize();
    xs::decimal_leaf::initialize();

    xs::QName_leaf::initialize();
    xs::NCName_leaf::initialize();
    xs::ID_leaf::initialize();
    xs::base64Binary_leaf::initialize();
    xs::hexBinary_leaf::initialize();
    xs::string_leaf::initialize();
    xs::normalizedString_leaf::initialize();
    xs::token_leaf::initialize();
    xs::positiveInteger_leaf::initialize();
    xs::negativeInteger_leaf::initialize();
    xs::nonPositiveInteger_leaf::initialize();
    xs::nonNegativeInteger_leaf::initialize();
    xs::decimal_leaf::initialize();
    xs::time_leaf::initialize();
    xs::dateTime_leaf::initialize();
    xs::duration_leaf::initialize();
    xs::date_leaf::initialize();
    xs::gMonth_leaf::initialize();
    xs::gYear_leaf::initialize();
    xs::gYearMonth_leaf::initialize();
    xs::gDay_leaf::initialize();
    xs::gMonthDay_leaf::initialize();
    xs::Name_leaf::initialize();
    xs::anyURI_leaf::initialize();
    xs::language_leaf::initialize();
    xs::IDREF_leaf::initialize();
    xs::IDREFS_leaf::initialize();
    xs::ENTITY_leaf::initialize();
    xs::ENTITIES_leaf::initialize();
    xs::NOTATION_leaf::initialize();
    xs::NMTOKEN_leaf::initialize();
    xs::NMTOKENS_leaf::initialize();
  }

  void boolean_leaf::model() {
    xmltype("xs:boolean");
  }

  void boolean_leaf::read_unicode_text(void *elm, const aka2::pstring &entity,
				       aka2::entity_complements &pcd) {
    xiso::leaf<bool>::read_unicode_text(elm, entity, pcd);
  }
  void boolean_leaf::write_text(const void *elm, std::ostream &ostm,
				aka2::entity_complements &pcd) {
    xiso::leaf<bool>::write_text(elm, ostm, pcd);
  }
  

  void int_leaf::model() { 
    xmltype("xs:int"); 
  }
  void unsignedInt_leaf::model() { 
    xmltype("xs:unsignedInt"); 
  }
  void long_leaf::model() { 
    xmltype("xs:long"); 
  }
  void unsignedLong_leaf::model() { 
    xmltype("xs:unsignedLong"); 
  }
  void short_leaf::model() { 
    xmltype("xs:short"); 
  }
  void unsignedShort_leaf::model() { 
    xmltype("xs:unsignedShort"); 
  }
  void float_leaf::model() { 
    xmltype("xs:float"); 
  }
  void double_leaf::model() { 
    xmltype("xs:double"); 
  }

  void integer_leaf::model() {
    xmltype("xs:integer");
  }

  void positiveInteger_leaf::model() { 
    xmltype("xs:positiveInteger"); 
  }
  
  void positiveInteger_leaf::read_unicode_text(void *elm, const aka2::pstring &entity,
					       aka2::entity_complements &ecomps) {
    long &value = *static_cast<long*>(elm);
    std::string digits = to_NMTOKEN(entity, "xs:positiveInteger", ecomps); 
    aka2::isstream istm(digits);

    istm >> value;
    if (istm.fail())
      throw aka2::error("Failed to parse xs:positiveInteger, "
			+ aka2::quote(digits) + ".",
			__FILE__, __LINE__);
    if (value <= 0)
      throw aka2::error("Wrong value for xs:positiveInteger, " 
			+ aka2::quote(digits) + ".", 
			__FILE__, __LINE__);
  }

  void negativeInteger_leaf::model() { 
    xmltype("xs:negativeInteger"); 
  }

  void negativeInteger_leaf::read_unicode_text(void *elm, const aka2::pstring &entity,
					       aka2::entity_complements &ecomps) {
    long &value = *static_cast<long*>(elm);
    std::string digits = to_NMTOKEN(entity, "xs:negativeInterger", ecomps);
    aka2::isstream istm(digits);
    istm >> value;
    if (istm.fail())
      throw aka2::error("Failed to parse xs:negativeInteger, "
			+ aka2::quote(digits) + ".",
			__FILE__, __LINE__);
    if (value >= 0)
      throw aka2::error("Wrong value for xs:negativeInteger, " 
			+ aka2::quote(digits) + ".", 
			__FILE__, __LINE__);
  }

  void nonPositiveInteger_leaf::model() { 
    xmltype("xs:nonPositiveInteger"); 
  }

  void nonPositiveInteger_leaf::read_unicode_text(void *elm, const aka2::pstring &entity,
						  aka2::entity_complements &ecomps) {
    long &value = *static_cast<long*>(elm);
    std::string digits = to_NMTOKEN(entity, "nonPositiveInteger", ecomps);
    aka2::isstream istm(digits);
    istm >> value;
    if (istm.fail())
      throw aka2::error("Failed to parse xs:nonPositiveInteger, "
			+ aka2::quote(digits) + ".",
			__FILE__, __LINE__);
    if (value > 0)
      throw aka2::error("Wrong value for xs:nonPositiveInteger, " 
			+ aka2::quote(digits) + ".", 
			__FILE__, __LINE__);
  }


  void nonNegativeInteger_leaf::model() { 
    xmltype("xs:nonNegativeInteger"); 
  }

  void nonNegativeInteger_leaf::read_unicode_text(void *elm, const aka2::pstring &entity,
						  aka2::entity_complements &ecomps) {
    long &value = *static_cast<long*>(elm);
    std::string digits = to_NMTOKEN(entity, "xs:nonNegativeInteger", ecomps);
    aka2::isstream istm(digits);
    istm >> value;
    if (istm.fail())
      throw aka2::error("Failed to parse xs:nonNegativeInteger, "
			+ aka2::quote(digits) + ".",
			__FILE__, __LINE__);
    if (value < 0)
      throw aka2::error("Wrong value for xs:nonNegativeInteger, " 
			+ aka2::quote(digits) + ".", 
			__FILE__, __LINE__);
  }
  

  void decimal_leaf::model() { 
    xmltype("xs:decimal"); 
  }

  void QName_leaf::model() {
    xmltype("xs:QName");
  }

  void QName_leaf::read_unicode_text(void *elm, const aka2::pstring &entity, 
				     aka2::entity_complements &ecomps) {
    aka2::qname &name = *static_cast<aka2::qname*>(elm);
    aka2::ustring collapsed = xs::whiteSpace_collapse(aka2::pivot_to_ucs2(entity));

    aka2::ustring::size_type pos = 
      aka2::ucs2_traits::find_first(collapsed.data(), collapsed.size(), aka2::uchar_t(':'));
    if (pos == aka2::pstring::npos) {
      if (is_NCName(collapsed)) {
	name = aka::qname(aka2::pivot, 
			  ecomps.get_prefixes().get_prefix_id(aka2::pstring()), 
			  aka2::ucs2_to_pivot(collapsed));
	return;
      }
      else {
	goto err_QName;
      }
    }
    else {
      aka2::ustring prefix = collapsed.substr(0, pos);
      aka2::ustring localname = collapsed.substr(pos + 1);
      if (is_NCName(prefix) && is_NCName(localname)) {
	name = 
	  aka2::qname(aka2::pivot, 
		      ecomps.get_prefixes().get_prefix_id(aka2::ucs2_to_pivot(prefix)),
		      aka2::ucs2_to_pivot(localname));
      }
      else {
	goto err_QName;
      }
    }
    return;

  err_QName:
    throw aka2::error("Wrong xs:QName, " + aka2::quote(ecomps.to_lcp(entity)) + "." , 
		      __FILE__, __LINE__);
  }

  void QName_leaf::write_text(const void *elm, std::ostream &ostm,
			      aka2::entity_complements &ecomps) {
    ostm << static_cast<const aka2::qname*>(elm)->qualified(ecomps.get_prefixes());
  }




  void NCName_leaf::model() {
    xmltype("xs:NCName");
  }

  void NCName_leaf::read_unicode_text(void *elm, const aka2::pstring &entity,
				      aka2::entity_complements &ecomps) {
    xs::NCName &ncname = *static_cast<xs::NCName*>(elm);
    ncname = to_NCName(entity, "xs:NCName", ecomps);
  }


  void ID_leaf::model() {
    xmltype("xs:ID");
  }

  void ID_leaf::read_unicode_text(void *elm, const aka2::pstring &entity,
				  aka2::entity_complements &ecomps) {
    
    xs::ID &ID = *static_cast<xs::ID*>(elm);
    ID = to_NCName(entity, "xs:ID", ecomps);
    if (!ecomps.check_id(ID)) {
      throw aka2::error("xs::ID, " + aka2::quote(ID) + ", has already appeared.",
			__FILE__, __LINE__);
    }
  }


  void base64Binary_leaf::model() { xmltype("xs:base64Binary"); }
  void base64Binary_leaf::read_unicode_text(void *e, const aka2::pstring &entity,
					    aka2::entity_complements &ecomps) {
    base64Binary &val = *static_cast<base64Binary*>(e);
    val = ecomps.to_lcp(entity);
  }

  void hexBinary_leaf::model() { xmltype("xs:hexBinary"); }
  void hexBinary_leaf::read_unicode_text(void *e, const aka2::pstring &entity,
					 aka2::entity_complements &ecomps) {
    hexBinary &val = *static_cast<hexBinary*>(e);
    val = ecomps.to_lcp(entity);
  }

  void string_leaf::model() { xmltype("xs:string"); }
  void string_leaf::read_unicode_text(void *e, const aka2::pstring &entity,
				      aka2::entity_complements &ecomps) {
    string &val = *static_cast<string*>(e);
    val = ecomps.to_lcp(entity);
  }

  void normalizedString_leaf::model() { xmltype("xs:normalizedString"); }
  void normalizedString_leaf::read_unicode_text(void *e, const aka2::pstring &entity,
						aka2::entity_complements &ecomps) {
    normalizedString &val = *static_cast<normalizedString*>(e);
    val = ecomps.to_lcp(entity);
  }

  void token_leaf::model() { xmltype("xs:token"); }
  void token_leaf::read_unicode_text(void *e, const aka2::pstring &entity,
				     aka2::entity_complements &ecomps) {
    token &val = *static_cast<token*>(e);
    val = ecomps.to_lcp(entity);
  }

  void time_leaf::model() { xmltype("xs:time"); }
  void time_leaf::read_unicode_text(void *e, const aka2::pstring &entity,
				    aka2::entity_complements &ecomps) {
    time &val = *static_cast<time*>(e);
    val = ecomps.to_lcp(entity);
  }
  
  void dateTime_leaf::model() { xmltype("xs:dateTime"); }
  void dateTime_leaf::read_unicode_text(void *e, const aka2::pstring &entity,
					aka2::entity_complements &ecomps) {
    dateTime &val = *static_cast<dateTime*>(e);
    val = ecomps.to_lcp(entity);
  }

  void duration_leaf::model() { xmltype("xs:duration"); }
  void duration_leaf::read_unicode_text(void *e, const aka2::pstring &entity,
					aka2::entity_complements &ecomps) {
    duration &val = *static_cast<duration*>(e);
    val = ecomps.to_lcp(entity);
  }
  
  void date_leaf::model() { xmltype("xs:date"); }
  void date_leaf::read_unicode_text(void *e, const aka2::pstring &entity,
				    aka2::entity_complements &ecomps) {
    date &val = *static_cast<date*>(e);
    val = ecomps.to_lcp(entity);
  }
  
  void gMonth_leaf::model() { xmltype("xs:gMonth"); }
  void gMonth_leaf::read_unicode_text(void *e, const aka2::pstring &entity,
				      aka2::entity_complements &ecomps) {
    gMonth &val = *static_cast<gMonth*>(e);
    val = ecomps.to_lcp(entity);
  }
  
  void gYear_leaf::model() { xmltype("xs:gYear"); }
  void gYear_leaf::read_unicode_text(void *e, const aka2::pstring &entity,
				     aka2::entity_complements &ecomps) {
    gYear &val = *static_cast<gYear*>(e);
    val = ecomps.to_lcp(entity);
  }
  
  void gYearMonth_leaf::model() { xmltype("xs:gYearMonth"); }
  void gYearMonth_leaf::read_unicode_text(void *e, const aka2::pstring &entity,
					  aka2::entity_complements &ecomps) {
    gYearMonth &val = *static_cast<gYearMonth*>(e);
    val = ecomps.to_lcp(entity);
  }
  
  void gDay_leaf::model() { xmltype("xs:gDay"); }
  void gDay_leaf::read_unicode_text(void *e, const aka2::pstring &entity,
				    aka2::entity_complements &ecomps) {
    gDay &val = *static_cast<gDay*>(e);
    val = ecomps.to_lcp(entity);
  }

  void gMonthDay_leaf::model() { xmltype("xs:gMonthDay"); }
  void gMonthDay_leaf::read_unicode_text(void *e, const aka2::pstring &entity,
					 aka2::entity_complements &ecomps) {
    gMonthDay &val = *static_cast<gMonthDay*>(e);
    val = ecomps.to_lcp(entity);
  }

  void Name_leaf::model() { xmltype("xs:Name"); }
  void Name_leaf::read_unicode_text(void *e, const aka2::pstring &entity,
				    aka2::entity_complements &ecomps) {
    Name &name = *static_cast<Name*>(e);
    name = to_Name(entity, "xs:Name", ecomps);
  }

  void anyURI_leaf::model() { xmltype("xs:anyURI"); }
  void anyURI_leaf::read_unicode_text(void *e, const aka2::pstring &entity,
				      aka2::entity_complements &ecomps) {
    anyURI &val = *static_cast<anyURI*>(e);
    val = ecomps.to_lcp(entity);
  }

  void language_leaf::model() { xmltype("xs:language"); }
  void language_leaf::read_unicode_text(void *e, const aka2::pstring &entity,
					aka2::entity_complements &ecomps) {
    language &val = *static_cast<language*>(e);
    val = ecomps.to_lcp(entity);
  }

  void IDREF_leaf::model() { xmltype("xs:IDREF"); }
  void IDREF_leaf::read_unicode_text(void *e, const aka2::pstring &entity,
				     aka2::entity_complements &ecomps) {
    xs::IDREF &idref = *static_cast<xs::IDREF*>(e);
    idref = to_NCName(entity, "xs:IDREF", ecomps);
  }

  void IDREFS_leaf::model() { xmltype("xs:IDREFS"); }
  void IDREFS_leaf::read_unicode_text(void *e, const aka2::pstring &entity,
				      aka2::entity_complements &ecomps) {
    IDREFS &val = *static_cast<IDREFS*>(e);
    val = ecomps.to_lcp(entity);
  }

  void ENTITY_leaf::model() { xmltype("xs:ENTITY"); }
  void ENTITY_leaf::read_unicode_text(void *e, const aka2::pstring &entity,
				      aka2::entity_complements &ecomps) {
    xs::ENTITY &ent = *static_cast<xs::ENTITY*>(e);
    ent = to_NCName(entity, "xs:ENTITY", ecomps);
  }

  void ENTITIES_leaf::model() { xmltype("xs:ENTITIES"); }
  void ENTITIES_leaf::read_unicode_text(void *e, const aka2::pstring &entity,
					aka2::entity_complements &ecomps) {
    ENTITIES &val = *static_cast<ENTITIES*>(e);
    val = ecomps.to_lcp(entity);
  }

  void NOTATION_leaf::model() { xmltype("xs:NOTATION"); }
  void NOTATION_leaf::read_unicode_text(void *e, const aka2::pstring &entity,
					aka2::entity_complements &ecomps) {
    NOTATION &val = *static_cast<NOTATION*>(e);
    val = ecomps.to_lcp(entity);
  }
  
  void NMTOKEN_leaf::model() { xmltype("xs:NMTOKEN"); }
  void NMTOKEN_leaf::read_unicode_text(void *e, const aka2::pstring &entity,
				       aka2::entity_complements &ecomps) {
    xs::NMTOKEN &nmtoken = *static_cast<xs::NMTOKEN*>(e);
    nmtoken = to_NMTOKEN(entity, "xs:NMTOKEN", ecomps);
  }

  void NMTOKENS_leaf::model() { xmltype("xs:NMTOKENS"); }
  void NMTOKENS_leaf::read_unicode_text(void *e, const aka2::pstring &entity,
					aka2::entity_complements &ecomps) {
    NMTOKENS &val = *static_cast<NMTOKENS*>(e);
    val = ecomps.to_lcp(entity);
  }

}

