/* -*- c++ -*- */
#ifndef AKAXISO2_BUILTIN_VALIDATOR_H__
#define AKAXISO2_BUILTIN_VALIDATOR_H__

/**
 * @file akaxiso2/builtin/validator.h
 * @brief validator functions.
 */

#include <akaxiso2/transcoders/pivot_transcoder.h>
#include <akaxiso2/framework/entity_complements.h>


namespace xs {

  /** This file provides */


  /**
  std::string to_NCName(const aka2::pstring &str, const char *type, 
			aka2::entity_complements &ecomps);

  std::string to_Name(const aka2::pstring &str, const char *type, 
		      aka2::entity_complements &ecomps);
  
  std::string to_NMTOKEN(const aka2::pstring &str, const char *type,
			 aka2::entity_complements &ecomps);
  
  std::string to_token(const aka2::pstring &str, 
		       aka2::entity_complements &ecomps);

  */
  

  /**
   * Based on XML-1.1 spec, because recent ICU uses Unicode version 4.0 or higher.
   */
  bool is_NameStartChar(aka2::uchar_t); /* \i */
  bool is_NameChar(aka2::uchar_t uch);  /* \c */


  /**
   * UCS-2 versions.
   */

  aka2::ustring whiteSpace_replace(const aka2::ustring &str);
  
  aka2::ustring whiteSpace_collapse(const aka2::ustring &str);

  aka2::ustring to_NCName(const aka2::ustring &str, const char *type);

  aka2::ustring to_Name(const aka2::ustring &str, const char *type);

  aka2::ustring to_NMTOKEN(const aka2::ustring &str, const char *type);
  
  aka2::ustring to_token(const aka2::ustring &str);


  bool is_Name(const aka2::ustring &unistr);
  bool is_NCName(const aka2::ustring &unistr);
  bool is_NMTOKEN(const aka2::ustring &unistr);
  bool is_QName(const aka2::ustring &unistr);


  /**
   * UTF-8 versions.
   */

  /**
  std::string whiteSpace_replace(const std::string &str);
  
  std::string whiteSpace_collapse(const std::string &str);
  
  */


  /**
   * pstring version
   */

  std::string to_NCName(const aka2::pstring &str, const char *type, 
			aka2::entity_complements &ecomps);

  std::string to_Name(const aka2::pstring &str, const char *type, 
		      aka2::entity_complements &ecomps);

  std::string to_NMTOKEN(const aka2::pstring &str, const char *type,
			 aka2::entity_complements &ecomps);
  
  std::string to_token(const aka2::pstring &str, 
		       aka2::entity_complements &ecomps);


}

#endif
