/* -*- c++ -*- */
#ifndef AKAXISO2_CONFIGURATION_H__
#define AKAXISO2_CONFIGURATION_H__

/**
 * @file akaxiso2/configuration.h
 * @brief configurations for akaxiso2 library
 */


/** @def LONGLONG                  @brief brief 64-bit signed integer */
/** @def ULONGLONG                 @brief 64-bit unsigned integer */
/** @def AKAXISO2_PACKAGE          @brief akaxiso2 package name */
/** @def AKAXISO2_VERSION          @brief akaxiso2 version */
/** @def AKAXISO2_USE_PTHREAD      @brief use pthread for mutex. */
/** @def TYPENAME                  @brief compiler workaround. */
/** @def AKAXISO2_USE_XERCESC      @brief use xerces-c++ as an XML-parser. */
/** @def AKAXISO2_USE_EXPAT        @brief expat as an XML-parser. */

/** @def AKAXISO2_USE_ICONV        @brief use iconv for transcoding. */
/** @def AKAXISO2_USE_ICU          @brief use ICU for transcoding. */

/**
 * @def AKAXISO2_USE_OWN_USTRING 
 * @brief define to use akaxiso2's aka2::ustring implementation.
 *
 * akaxiso2 has UCS-2 string class as aka2::ustring.
 * For systems that wchar_t is UCS-2 based, aka2::ustring would be typedef name of std::wstring.
 * For typical GCC environment, wchar_t is UCS-4, therefore akaxiso2 should define 
 * std::basic_string<unsigned short> as an aka2::ustring by itself.
 */

/** 
 * @def AKAXISO2_IMPLEMENT_CHAR_TRAITS
 * @brief Add char_traits<> implementation for aka2::ustring.
 *
 * Implementation for char_traits<aka2::uchar_t> should be added to 
 * some GCC's STL (3.0~3.3) because of missing template-method implementation.
 * By defining this macro, char_traits<> method implementation in akaxiso2 will be used. 
 */

/** @def AKAXISO2_MISSING_SSTREAM_IN_IOSFWD
 * @brief define this macro if <iowfd> does not include <sstream> stuff.
 *
 * This macro is required for gcc-2.95.3.
 */

/** @def AKAXISO2_USE_ISTRSTREAM
 * @brief use std::istrstream as aka2::isstream.
 *
 * For gcc-2.95.3, isstream does not work.
 * akaxiso2 will use std::istrstream as aka2::isstream.
 */

/** @def AKAXISO2_ISTREAM_READSOME_SUPPORTED
 * @brief define this macro if istream::readsome() is supported.
 */



#define AKAXISO2_PACKAGE "akaxiso2"
#define AKAXISO2_VERSION "2.0-beta3"

#ifdef __unix__
# include <akaxiso2/config.h>
#endif

# ifdef __APPLE_CC__
# include <akaxiso2/config.h>
#endif

/* Make sure to define _WIN32 for BCB. */
#if defined(__WIN32__) /* BCB style */ && !defined(_WIN32)
# define _WIN32 1
#endif

#ifdef _WIN32
# include <akaxiso2/config_win32.h>
#endif


/** Compilers */

#ifdef __GNUC__
# define TYPENAME typename
# define LONGLONG long long
# define ULONGLONG unsigned long long
# define AKAXISO2_USE_OWN_USTRING 1
# if (__GNUC__ == 3) && (__GNUC_MINOR__ <= 3)
#  define AKAXISO2_IMPLEMENT_CHAR_TRAITS 1
# endif
# if (__GNUC__ == 2) && (__GNUC_MINOR__ == 96)
#  define AKAXISO2_MISSING_SSTREAM_IN_IOSFWD 1
# endif
# if (__GNUC__ == 2) && (__GNUC_MINOR__ == 95)
#  define AKAXISO2_USE_ISTRSTREAM 1
# endif
#endif

#ifdef _MSC_VER
# if _MSC_VER >= 1300 /* VC7 or later */
#  pragma warning( disable : 4345 ) /* Warning for POD-type object initialization */
#  pragma warning( disable : 4996 ) /* Warning for deprecated API's. */
#  ifdef _NATIVE_WCHAR_T_DEFINED
#   define AKAXISO2_NATIVE_WCHAR_T_DEFINED
#  endif
#  define TYPENAME typename
# else /* For VC6 */
#  pragma warning( disable : 4786 )
#  pragma warning( disable : 4284 )
#  define TYPENAME
# endif
# ifndef LONGLONG
#  define LONGLONG _int64
# endif
# ifndef ULONGLONG
#  define ULONGLONG unsigned _int64
# endif
# ifdef AKAXISO2_USE_XERCESC
#  ifdef _DEBUG
#   pragma comment(lib, "xerces-c_2D.lib")
#  else
#   pragma comment(lib, "xerces-c_2.lib")
#  endif 
# endif
# ifdef AKAXISO2_USE_ICU
#  ifdef _DEBUG
#   pragma comment(lib, "icuucd.lib")
#  else
#   pragma comment(lib, "icuuc.lib")
#  endif
#   pragma comment(lib, "icudt.lib")
# endif
#endif

#ifdef __BORLANDC__
# define TYPENAME typename
# if __BORLANDC__ >= 0x0560
#  define LONGLONG long long
#  define ULONGLONG unsigned long long
# endif
# ifdef AKAXISO2_USE_XERCESC
#  pragma link "XercesLib.lib"
# endif
#endif

#if !defined(AKAXISO2_USE_XERCESC) && !defined(AKAXISO2_USE_EXPAT)
# error "XML parser is not specified."
#endif


#endif /* AKAXISO2_CONFIGURATION_H__ */
