/* -*- c++ -*- */
#ifndef AKAXISO2_EXCEPTION_H__
#define AKAXISO2_EXCEPTION_H__

/**
 * @file akaxiso2/exception.h
 * @brief akaxiso exception
 */

#include <exception>
#include <string>

namespace aka2 {
  
  /** 
   * @brief Base class of any exception in akaxiso. 
   *
   * All excpetion classes in akaxiso library are derived from aka2::error class.
   * aka2::error is derived from std::exception.
   */
  struct error : public std::exception {
    /** Constructor
     * @param msg error message.
     * @param file file name, usually __FILE__.
     * @param line line number, usually __LINE__.
     */
    explicit error(const std::string &msg, const char *file, const unsigned long line);
    virtual ~error() throw();
    virtual const char *what() const throw();
  protected:
    error() {}
    std::string msg_;
  };


  struct positioned_error : error {
    explicit positioned_error(const std::string &msg, 
			      const char *file, const unsigned long file_line,
			      const std::string &path = std::string(),
			      const std::string &source = std::string(), 
			      long line = -1, long column = -1);
    positioned_error(const error &e);
    positioned_error(const positioned_error &e);
    void set_position(const std::string &source, long line, long column); 
    virtual ~positioned_error() throw();
    virtual const char *what() const throw();
  private:
    std::string source_;
    std::string path_;
    long line_;
    long column_;
    mutable std::string positioned_msg_;
  };


  struct tagged_error : public error {
    explicit tagged_error(const std::string &caption, 
			  const std::string &tagname,
			  const std::string &msg, 
			  const char *file, const unsigned long line);
    virtual ~tagged_error() throw();
  };

}

#endif
