#include "closure.h"
#include "type_registry.h"

using namespace aka2;

namespace {
  qname enclose_name_;
  qname disclose_name_;
}

enclose_op enclose_op::op_;
disclose_op disclose_op::op_;

const qname &enclose_op::get_typename() const {
  return enclose_name_;
}

void enclose_op::initialize() {
  if (enclose_name_.empty())
    enclose_name_ = qname("aka2:&enclose");
}


const qname &disclose_op::get_typename() const {
  return disclose_name_;
}

void disclose_op::initialize() {
  if (disclose_name_.empty())
    disclose_name_ = qname("aka2:&disclose");
}
