/* -*- c++ -*- */
#ifndef AKAXISO2_FRAMEWORK_CLOSURE_H__
#define AKAXISO2_FRAMEWORK_CLOSURE_H__

#include <akaxiso2/framework/operators.h>

#include <assert.h>

namespace aka2 {

  class enclose_op : public element_op {
  public:
    virtual schematype_id get_schematype() const { return enclose_id; }
    virtual const qname &get_typename() const;
    virtual const attribute_types* get_attribute_types() const { return 0; }
    virtual const attribute_type *get_anyattr_type() const { return 0; }
    virtual bool equals(const void *lhs, const void *rhs) const { return true; }

    virtual void construct(void *e) const { assert(!"Must not reach here."); }
    virtual void copy_construct(void *e, const void *src) const { 
      assert(!"Must not reach here.");  
    }
    virtual void destruct(void *e) const { assert(!"Must not reach here.");  }
    virtual size_t class_size() const { assert(!"Must not reach here."); return 0; }
    static enclose_op op_;

    static void initialize();
  };



  class disclose_op : public element_op {
  public:
    virtual schematype_id get_schematype() const { return disclose_id; }
    virtual const qname &get_typename() const;
    virtual const attribute_types* get_attribute_types() const { return 0; }
    virtual const attribute_type *get_anyattr_type() const { return 0; }
    virtual bool equals(const void *lhs, const void *rhs) const { return true; }

    virtual void construct(void *e) const { assert(!"Must not reach here."); }
    virtual void copy_construct(void *e, const void *src) const { 
      assert(!"Must not reach here.");  
    }
    virtual void destruct(void *e) const { assert(!"Must not reach here.");  }
    virtual size_t class_size() const { assert(!"Must not reach here."); return 0; }
    static disclose_op op_;

    static void initialize();
  };

}

#endif
