/* -*- c++ -*- */
#ifndef AKAXISO2_FRAMEWORK_PTRMEMBER_H__
#define AKAXISO2_FRAMEWORK_PTRMEMBER_H__

#include <akaxiso2/util/deep_ptr.h>
#include <akaxiso2/framework/operators.h>

namespace aka2 {

  template<class VL, class V>
  struct ptrmember_op_dispatcher : public ptrmember_op {
  public:
    virtual const qname &get_typename() const { return VL::get_xmltype(); }
    virtual const element_op& get_value_op() const {
      return VL::dispatcher_;
    };
    virtual void construct(void *elm) const {
      new (elm) V();
    }
    virtual void destruct(void *elm) const {
      static_cast<V*>(elm)->~V();
    }
    virtual void copy_construct(void *dest, const void *src) const {
      new (dest) V(*static_cast<const V*>(src));
    }
    virtual void *dereference(void *elm) const { 
      V &pv = *static_cast<V*>(elm);
      return pv.get();
    }
    virtual const void *dereference(const void *elm) const { 
      const V &pv = *static_cast<const V*>(elm);
      return pv.get();
    }
    virtual void set(void *elm, void *v) const {
      static_cast<V*>(elm)->reset(static_cast<TYPENAME V::value_type*>(v));
    }
    static ptrmember_op_dispatcher<VL, V> dispatcher_;
  };

  template<class VL, class V>
  ptrmember_op_dispatcher<VL, V> ptrmember_op_dispatcher<VL, V>::dispatcher_;

  template<class V, class VL>
  struct ptrmember_op_stub : ptrmember_op_dispatcher<VL, V> {
  };


}

#endif
