/* -*- c++ -*- */
#ifndef AKAXISO2_FRAMEWORK_TYPE_REGISTRY_H__
#define AKAXISO2_FRAMEWORK_TYPE_REGISTRY_H__

/** @file akaxiso2/classes/type_registry.h */

#include <akaxiso2/framework/operators.h>

namespace aka2 {

  struct type_entry {
    typedef void (*uninitializer)();

    type_entry(element_op &op, uninitializer uni) 
      : op_(op), uninitializer_(uni), refcount_(0) {}

    element_op &op_; 
    uninitializer uninitializer_;
    int refcount_;
  };

  class type_registry {
    typedef std::map<const element_op*, type_entry> typemap;
    typemap types_;
  public:
    void initialize(){ remove_all(); }
    void uninitialize(){ remove_all(); }

    bool add(element_op &op, type_entry::uninitializer uni);

    void remove_all();

    template<class L>
    bool add(const L& l) {
      return add(L::dispatcher_, &L::uninitialize);
    }
  };

} // namespace aka2

#endif
