/* -*- c++ -*- -*/
#ifndef AKAXISO2_FRAMEWORK_XMLTYPE_H__
#define AKAXISO2_FRAMEWORK_XMLTYPE_H__

/**
 * @file akaxiso2/framework/xmltype.h
 * @brief type name of serializable classes
 */

#include <akaxiso2/framework/qname.h>
#include <typeinfo>

namespace aka2 {

  /**
   * @brief XML type name for serializable classes 
   * @param L leaf class
   */
  template<class L>
  struct xmltype_statics {

    /**
     * @brief set type name.
     * @param name type name to set
     */
    static void xmltype(const std::string &name) {
      L::xmltype_ = aka2::qname(name);
    }

    /**
     * @brief get type name
     * @return type name set by xmltype(), or typeid(L).name() if type name is not specified yet, 
     */
    static const qname &get_xmltype() {
      if (xmltype_.empty())
	xmltype_ = qname(typeid(L).name());
      return L::xmltype_;
    }
    static qname xmltype_; 
  };

  template<class L>
  qname xmltype_statics<L>::xmltype_;
}

#endif
