/* -*- c++ -*- */
#ifndef AKAXISO2_TRANSCODERS_BUILTIN_TRANSCODERS_H__
#define AKAXISO2_TRANSCODERS_BUILTIN_TRANSCODERS_H__

/**
 * @file akaxiso2/transcoders/builtin_transcoders.h 
 * @brief akaxiso2 builtin transcoder classes.
 */

#include <akaxiso2/transcoders/transcoder.h>

namespace aka2 {

  /** @brief Formatter with null encoding translator. */
  class null_transcoder : public transcoder {
    friend class builtin_transcoder;
    null_transcoder() {}
  public:
    virtual ~null_transcoder() {}
    virtual bool transcode(const char *to_convert, size_t length);

    virtual void reset();
  };


  class utf8_to_ucs2_transcoder : public transcoder {
    friend class builtin_transcoder;
    utf8_to_ucs2_transcoder() { } 
  public:
    virtual ~utf8_to_ucs2_transcoder() {}
    virtual bool transcode(const char *to_convert, size_t length);

    virtual void reset();
  };


  class ucs2_to_utf8_transcoder : public transcoder {
    friend class builtin_transcoder;
    ucs2_to_utf8_transcoder() { }
  public:
    virtual ~ucs2_to_utf8_transcoder() {}
    virtual bool transcode(const char *to_convert, size_t length);

    virtual void reset();
  };


  class builtin_transcoder {
  public:
    static transcoder *create(const std::string &tocode, const std::string &fromcode);
    static transcoder *create_no_throw(const std::string &tocode, const std::string &fromcode);
  };
  
} // namespace aka2


#if defined(AKAXISO2_USE_ICU) && !defined(AKAXISO2_DEFAULT_TRANSCODER)
# define AKAXISO2_DEFAULT_TRANSCODER "ICU"
# include <akaxiso2/transcoders/icu_transcoder.h>
namespace  aka2 {
  typedef icu_transcoder default_transcoder;
}
#endif

#if defined(AKAXISO2_USE_ICONV) && !defined(AKAXISO2_DEFAULT_TRANSCODER)
# define AKAXISO2_DEFAULT_TRANSCODER "iconv"
# include <akaxiso2/transcoders/iconv_transcoder.h>
namespace   aka2 {
  typedef iconv_transcoder default_transcoder;
}
#endif

#if !defined(AKAXISO2_DEFAULT_TRANSCODER) && defined(_WIN32)
# define AKAXISO2_DEFAULT_TRANSCODER "MLang/Win32"
# include <akaxiso2/transcoders/win32_transcoder.h>
namespace aka2 {
  typedef win32_encodings default_transcoder;
}
#endif

#if !defined(AKAXISO2_DEFAULT_TRANSCODER)
# define AKAXISO2_DEFAULT_TRANSCODER "akaxiso2-builtin(UTF-8/UCS-2)"
namespace  aka2 {
  typedef builtin_transcoder default_transcoder;
}
#endif




#endif
