/* -*- c++ -*- */
#ifndef AKAXISO2_TRANSCODERS_ICONV_TRANSCODER_H__
#define AKAXISO2_TRANSCODERS_ICONV_TRANSCODER_H__

/**
 * @file akaxiso2/transcoders/iconv_transcoder.h 
 * @brief transcoder by using iconv transcoder.
 */

#include <akaxiso2/configuration.h>

#ifdef AKAXISO2_USE_ICONV

#include <akaxiso2/transcoders/transcoder.h>
#include <akaxiso2/unicode/string_buffer.h>
#include <iconv.h>

namespace aka2 {

  class iconv_transcoder : public transcoder {
    iconv_t cd_;
  protected:
    iconv_transcoder(iconv_t cd) : cd_(cd) {}
  public:
    virtual ~iconv_transcoder();

    virtual bool transcode(const char *to_convert, size_t length);
    virtual void reset();

    static transcoder *create(const std::string &tocode, const std::string &fromcode);
  };
} // namespace aka2

#endif

#endif
