/* -*- c++ -*- */
#ifndef AKAXISO2_TRANSCODERS_ICU_TRANSCODER_H__
#define AKAXISO2_TRANSCODERS_ICU_TRANSCODER_H__

/**
 * @file akaxiso2/transcoders/icu_transcoder.h 
 * @brief transcoder by using icu transcoder.
 */

#include <akaxiso2/configuration.h>

#ifdef AKAXISO2_USE_ICU

#include <akaxiso2/transcoders/transcoder.h>
#include <akaxiso2/unicode/string_buffer.h>
#include <unicode/ucnv.h>

namespace aka2 {

  class icu_transcoder : public ubuffered_transcoder {
    UConverter *ucnv_to_;
    UConverter *ucnv_from_;
  protected:
    icu_transcoder(UConverter *ucnv_to, UConverter *ucnv_from) 
      : ubuffered_transcoder(),
	ucnv_to_(ucnv_to), ucnv_from_(ucnv_from) {}

    bool from_inbuf();
    bool to_outbuf(const aka2::uchar_t *pivot_current);

    static UConverter* create_converter(const std::string &converterName);

  public:
    virtual ~icu_transcoder();
    virtual void reset();
    static transcoder *create(const std::string &tocode, const std::string &fromcode);
  };
  
} // namespace aka2

#endif

#endif
