#include "stateful_transcoder.h"
#include "../exception.h"
#include "encoding_name.h"

#include <assert.h>

using namespace aka2;

stateful_transcoder::stateful_transcoder(transcoder *tc, 
					 const struct char_mark *bom, bool bom_to_add) 
  : transcoder_(tc), current_result_(true), 
    bom_(bom), bom_to_add_(bom_to_add), bom_to_check_(false) {
  reset();
} 


stateful_transcoder::~stateful_transcoder() { 
  if (transcoder_)
    delete transcoder_;
  transcoder_ = 0;
}

bool stateful_transcoder::transcode(const char *to_convert, unsigned int length) {

  bool res = transcoder_->transcode(to_convert, length);

  if (bom_to_check_) {
    bool bom_checked;
    if (bom_to_add_)
      bom_checked = transcoder_->write_bom(bom_);
    else 
      bom_checked = transcoder_->clear_bom(bom_);
    if (bom_checked)
      bom_to_check_ = false;
  }
  return res;
}  


void stateful_transcoder::clear_transcoded_buffer() {
  transcoder_->clear_transcoded_buffer();
}


void stateful_transcoder::reset() {
  if (!current_result_) {
    transcoder_->reset();
    transcoder_->inbuf_.clear();
    transcoder_->outbuf_.clear();
    current_result_ = true;
  }
  /* enable BOM check */
  bom_to_check_ = (bom_ != 0);
}



stateful_transcoder *aka2::stateful_transcoder::create(const std::string &tocode, 
						       const std::string &fromcode,
						       bool bom_to_add,
						       transcoder_factory tf) {
  transcoder *tc = create_transcoder(tocode, fromcode, tf);
  tc->set_encoding_types(tocode, fromcode);
  const struct char_mark *bom = get_unicode_bom(tocode);
  return new stateful_transcoder(tc, bom, bom_to_add);
}

