/* -*- c++ -*- */
#ifndef AKAXISO2_TRANSCODERS_WIN32_TRANSCODER_H__
#define AKAXISO2_TRANSCODERS_WIN32_TRANSCODER_H__

/**
 * @file akaxiso2/transcoders/win32_transcoder.h 
 * @brief transcoder by using win32 transcoder.
 */

#include <akaxiso2/configuration.h>

#ifdef _WIN32
#include <akaxiso2/transcoders/transcoder.h>
#include <akaxiso2/unicode/string_buffer.h>
#include <mlang.h>

#include <vector>


namespace aka2 {

  class win32_encoding {
  public:
    // encoding name in registry.
    std::string name_;
    // sort key
    std::string key_;
    // preserve real encoding name if alias.
    std::string realname_;
    // preserve code page if not alias.
    UINT cp_;
  };


  class win32_encodings {
  public:
    typedef std::vector<win32_encoding> encodings;

  private:
    static encodings encodings_;
    static encodings aliases_;

    static void scan_aliases();
    static void scan_codepages();
    static void mlang_scan_codepages();
    static HMODULE mlang_dll_; 
    static IClassFactory *factory_;
    static int mlang_initialize();
  public:
    static void initialize();
    static void uninitialize();
    static UINT get_cp(const std::string &encoding_name);
    static std::string get_default_encoding();
    static const encodings &get_encodings() { return encodings_; }
    static const encodings &get_aliases() { return aliases_; }
    static void get_mlang(IMultiLanguage **mlang);
    static bool is_mlang_available() { return mlang_dll_ != NULL; }
    static transcoder *create(const std::string &tocode, const std::string &fromcode);
  };


  class win32_transcoder : public ubuffered_transcoder {
    UINT cp_to_;
    UINT cp_from_;
  protected:
    win32_transcoder(UINT cp_to, UINT cp_from) 
      : ubuffered_transcoder(), cp_to_(cp_to), cp_from_(cp_from) {}
    virtual bool from_inbuf();
    virtual bool to_outbuf(const aka2::uchar_t *pivot_current);
  public:
    virtual ~win32_transcoder() { }
    virtual void reset();
    static transcoder *create(const std::string &tocode, const std::string &fromcode);
  };
  

  class mlang_transcoder : public ubuffered_transcoder {
    UINT cp_to_;
    UINT cp_from_;
    DWORD to_context_;
    DWORD from_context_;
    IMultiLanguage *mlang_;
  protected:
    mlang_transcoder(UINT cp_to, UINT cp_from, IMultiLanguage *mlang) 
      : ubuffered_transcoder(), cp_to_(cp_to), cp_from_(cp_from), 
        to_context_(0), from_context_(0), mlang_(mlang) {}
    virtual bool from_inbuf();
    virtual bool to_outbuf(const aka2::uchar_t *pivot_current);
  public:
    virtual ~mlang_transcoder();
    virtual void reset();
    static transcoder *create(const std::string &tocode, const std::string &fromcode);
  };

} // namespace aka2

#endif

#endif

