/* -*- c++ -*- */
#ifndef AKAXISO2_UNICODE_UCS2_TRAITS_H__
#define AKAXISO2_UNICODE_UCS2_TRAITS_H__

/**
 * @file akaxiso2/unicode/ucs2_traits.h
 * @brief ucs2 codepoint traits.
 */

#include <akaxiso2/unicode/ustring.h>

namespace aka2 {

  struct ucs2_traits {
    static int compare(const uchar_t *lhs, const uchar_t *rhs);
    static int compare(const uchar_t *lhs, const uchar_t *rhs, size_t size);
    
    static int find_first(const uchar_t *buffer, size_t size, uchar_t to_find);
    
    /** Returns char length, not string length. */
    static size_t char_length(const uchar_t *buffer) { return 1; }
    
    /** Returns string length. */
    static size_t length(const uchar_t *buffer);

    static const char *encoding();
  };

}

#endif
