/* -*- c++ -*- */
#ifndef AKAXISO2_UTIL_SCOPED_PTR_H__
#define AKAXISO2_UTIL_SCOPED_PTR_H__

/**
 * @file akaxiso2/util/scoped_ptr.h
 * @brief scoped pointer.
 * @author Tetsu Yoshioka (yoshioka@users.sourceforge.jp)
 */

namespace aka2 {

struct normal_delete {
  template<class T>
  void operator()(T* t) const { delete t; }
};

template <class T, class delete_functor = normal_delete>
class scoped_ptr {
public:
  typedef T element_type;

  explicit scoped_ptr(T* ptr = 0) : ptr_(ptr) {}
  ~scoped_ptr() {
    delete_functor()(ptr_);
  }

  void reset(T* ptr = 0) {
    delete_functor()(ptr_);
    ptr_ = ptr;
  }

  T* get() const { return ptr_; }

  T& operator*() const { return *ptr_; }
  T* operator->() const { return ptr_; }

private:
  scoped_ptr(const scoped_ptr&);
  scoped_ptr& operator =(const scoped_ptr&);
  
  T* ptr_;
};

} // namespace aka2

#endif
