/* -*- c++ -*- */
#ifndef cuppa_tokenizer_h
#define cuppa_tokenizer_h

/**
 * @file akaxiso2/util/tokenizer.h
 * @brief tokenizer class template.
 *
 * This file is from cuppa project.
 * See http://sourceforge.jp/projects/cuppa
 *    Copyright (c) 2002 cuppa project
 *
 *  Permission is hereby granted, free of charge, to any person obtaining
 *  a copy of this software and associated documentation files (the
 *  "Software"), to deal in the Software without restriction, including
 *  without limitation the rights to use, copy, modify, merge, publish,
 *  distribute, sublicense, and/or sell copies of the Software, and to
 *  permit persons to whom the Software is furnished to do so, subject to
 *  the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included
 *  in all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 *  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 *  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 *  CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 *  TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 *  SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */



#include <iostream>
#include <string>


/**
 * @namespace cuppa
 * @brief cuppa project namespace.
 * See http://sourceforge.jp/projects/cuppa
 */

namespace cuppa {

  template<class E /* =char */ /* commented out for VC6 workaround. */>
  class tokenizer {
  public:
    typedef std::basic_string<E> string_type;
    typedef typename string_type::size_type   size_type;

    explicit tokenizer(const string_type& str = string_type())
      : str_(str), off_(0) {}

    void set_string(const string_type& str) { str_ = str; }
    bool has_more_token(const string_type& delim) const;
    string_type next_token(const string_type& delim);
    bool next_token(const string_type& delim, string_type& result)
    { result = next_token(delim); return !result.empty(); }
    void rewind() { off_ = 0; }

  private:
    string_type str_;
    size_type   off_;
  };

  template<class E>
  inline bool
  tokenizer<E>::has_more_token(const string_type& delim) const {
    return off_ == string_type::npos ?
      false : str_.find_first_not_of(delim, off_) != string_type::npos;
  }

  template<class E>
  inline typename tokenizer<E>::string_type
  tokenizer<E>::next_token(const string_type& delim) {
    size_type first = str_.find_first_not_of(delim, off_);
    if ( first == string_type::npos ) {
      return string_type();
    }
    off_  = str_.find_first_of(delim, first);
    return str_.substr(first, off_ == string_type::npos ? off_ : off_ - first);
  }
  
}

#endif
