#!/bin/bash

OK_COUNT=0
NG_COUNT=0
test_program()
{
    PROGRAM=$1
    OPT=$2
    if ./$PROGRAM $OPT > $PROGRAM.xml  && ./$PROGRAM -d < $PROGRAM.xml > /dev/null
	then
	rm $PROGRAM.xml
	echo -n '.'
	OK_COUNT=`expr $OK_COUNT + 1`
    else
	echo $PROGRAM NG.
	NG_COUNT=`expr $NG_COUNT + 1`
    fi
}

test_deserializer() 
{
    PROGRAM=$1
    OPT=$2

    if ./$PROGRAM $OPT > $PROGRAM.xml && ./deserializer < $PROGRAM.xml > /dev/null
	then
	rm $PROGRAM.xml
	echo -n '.'
	OK_COUNT=`expr $OK_COUNT + 1`
    else
	echo "Deserialize document from $PROGRAM failed."
	NG_COUNT=`expr $NG_COUNT + 1`
    fi
}

test_program project -s
test_program projectmap -s1
test_program projectmap -s2
test_program basket -s
test_program model_array -s
test_program all_test -s


test_deserializer project -s
test_deserializer projectmap -s1
test_deserializer projectmap -s2
test_deserializer basket -s
test_deserializer model_array -s
test_deserializer all_test -s






TOTAL=`expr $OK_COUNT + $NG_COUNT`
echo
echo
echo "Total : $TOTAL   OK : $OK_COUNT  NG: $NG_COUNT"
ls -f *.xml 2> /dev/null

exit 0
