//CUPPA:include=+
#include <akaxiso2/akaxiso2.h>
#include <akaxiso2/content_model.h>
//CUPPA:include=-
#include <cppunit/extensions/HelperMacros.h>
#include <cppunit/TestAssert.h>

//CUPPA:namespace=+
//CUPPA:namespace=-

namespace {

  typedef std::vector<aka::item> choice;
  
  struct choice_leaf : public aka::sequential_choice<choice, choice_leaf> {
    void model() {
      item("val1", xiso::leaf<std::string>());
    }
  };

  typedef std::vector<std::string> strings;
  typedef aka::sequential_array<strings> strings_leaf;

  struct root_sequence {
    choice choice_;
    strings strings_;
  };

  struct root_sequence_leaf : aka::sequence<root_sequence, root_sequence_leaf> {
    void model() {
      member("&choice", &root_sequence::choice_, choice_leaf(), 5, 15, true);
      member("string", &root_sequence::strings_, strings_leaf(), 5, 15, true);
    }
  };

  typedef std::vector<aka::item> root_choice;

  struct root_choice_leaf : aka::sequential_choice<root_choice, root_choice_leaf> {
    void model() {
      occurrence(2, 2, true);
      item("&choice", choice_leaf(), 5, 15, true);
      item("string", strings_leaf(), 5, 15, true);
    }
  };

}


class emptiableTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE(emptiableTest);
//CUPPA:suite=+
//   CPPUNIT_TEST(test_emptiable_sequence);
  CPPUNIT_TEST(test_emptiable_choice);
//CUPPA:suite=-
  CPPUNIT_TEST_SUITE_END();
private:

  // your stuff...

public:

  virtual void setUp() { 
    aka::initialize();
  }
  virtual void tearDown() { 
    aka::uninitialize();
  }

//CUPPA:decl=+
  void test_emptiable_sequence() {
    aka::doctype("emptiables", root_sequence_leaf());
    test_emptiables();
    test_30items();
    test_03items();
    test_50items();
    test_05items();
    test_55items();
  }

  void test_emptiable_choice() {
    aka::doctype("emptiables", root_choice_leaf());
    test_emptiables();
//     test_30items();
//     test_03items();
//     test_50items();
//     test_05items();
//     test_55items();
  }


  void test_emptiables() {

    const char * document = "<emptiables/>";
    aka::deserialize(document);
  }

  void test_30items() {

    const char * document = 
      "<emptiables>\n"
      "<val1>test</val1>\n"
      "<val1>test</val1>\n"
      "<val1>test</val1>\n"
      "</emptiables>";
    try {
      aka::deserialize(document);
    }
    catch ( ... ) {
      return;
    }
    CPPUNIT_FAIL("Error not reported.");
  }
  void test_03items() {
    const char * document = 
      "<emptiables>\n"
      "<string>test</string>\n"
      "<string>test</string>\n"
      "<string>test</string>\n"
      "</emptiables>";
    try {
      aka::deserialize(document);
    }
    catch ( ... ) {
      return;
    }
    CPPUNIT_FAIL("Error not reported.");
  }
  void test_50items() {
    const char * document = 
      "<emptiables>\n"
      "<val1>test</val1>\n"
      "<val1>test</val1>\n"
      "<val1>test</val1>\n"
      "<val1>test</val1>\n"
      "<val1>test</val1>\n"
      "</emptiables>";
    aka::deserialize(document);
  }
  void test_05items() {
    const char * document = 
      "<emptiables>\n"
      "<string>test</string>\n"
      "<string>test</string>\n"
      "<string>test</string>\n"
      "<string>test</string>\n"
      "<string>test</string>\n"
      "</emptiables>";
    aka::deserialize(document);
  }
  void test_55items() {
    const char * document = 
      "<emptiables>\n"
      "<val1>test</val1>\n"
      "<val1>test</val1>\n"
      "<val1>test</val1>\n"
      "<val1>test</val1>\n"
      "<val1>test</val1>\n"
      "<string>test</string>\n"
      "<string>test</string>\n"
      "<string>test</string>\n"
      "<string>test</string>\n"
      "<string>test</string>\n"
      "</emptiables>";
    aka::deserialize(document);
  }
//CUPPA:decl=-
};

//CUPPA:impl=+
//CUPPA:impl=-

CPPUNIT_TEST_SUITE_REGISTRATION(emptiableTest);
