#include <akaxiso/akaxiso.h>
#include <iostream>
#include "schema.h"

int main() {
  aka::initialize();
  xs::define_schemadoc();
  // Parse

  aka::document doc;
  try {
    doc = aka::deserialize_stdin();
  }
  catch (const std::exception &e) {
    std::cerr << e.what() << std::endl;
    std::cerr << "Parse error detected.  Abort immediately." << std::endl;
    exit(1);
  }
  catch ( ... ) {
    std::cerr << "Unhandled parse error detected.  Abort immediatedly." << std::endl;
    exit(1);
  }
  aka::serialize(doc, std::cout);
  aka::uninitialize();
}
