/* -*- c++ -*- */
#ifndef OSIXAKA2_DOT_GENERATOR_H__
#define OSIXAKA2_DOT_GENERATOR_H__

#include <akaxiso2/akaxiso2.h>
#include <osixaka2/userdefs.h>
#include <osixaka2/registry.h>
#include <osixaka2/cpp_namer.h>
#include <fstream>

namespace osx {

  class dot_generator {
    registry &registry_;
    cpp_namer namer_;
    std::ostream &ostm_;
    qname_set generated_;

    void generate_for_unit(const registry_unit &unit);
    void begin_dot_file();
    void end_dot_file();

    void generate_tree(const type_ref &type);
    void write_dir(const type_ref &start_edge, const type_ref &end_edge);

    void generate_sequence(const user_class &def);
    void generate_choice(const user_class &def);
    void generate_all(const user_class &def);
    void generate_array(const user_class &def);
    void generate_simplecontent(const user_class &def);
    void generate_simpletype(const user_class &def);
    std::string escape(const aka::qname &to_escape) const;
    static std::string quote(const aka::qname &to_quote);

    typedef std::map<aka::qname, long, aka::qname_less> end_edges;
    typedef std::map<aka::qname, end_edges, aka::qname_less> edges;
    edges edges_;
  public:
    dot_generator(registry &reg, std::ostream &ostm) 
      : registry_(reg), namer_(reg), ostm_(ostm) { }
    void generate();
  };

}

#endif
