/* -*- c++ -*- */
#ifndef OSIXAKA2_H__
#define OSIXAKA2_H__

#include <akaxiso2/akaxiso2.h>
#include <osixaka2/registry.h>
#include <osixaka2/exception.h>
#include <osixaka2/schema_generator.h>

namespace osx {

  class osixaka2 {
    std::ostream &ostm_;
    bool use_soft_array_;
    bool verbose_;
    std::string basedir_;
    std::string outputdir_;
    registry registry_;

    std::string instantiate_xiso_name_;

    void create_default_preference();
    aka::shared_ptr<preference> pref_;
 
    void generate_all_in_one();
    void generate_target_ns();
    void merge_defaults();
  public:
    osixaka2(std::ostream &ostm, bool use_soft_array, bool verbose)
      : ostm_(ostm), use_soft_array_(use_soft_array), verbose_(verbose), 
	pref_(0) {}

    int preprocess(const std::string &filepath);
    int process();
    int akaxisonize(int level);
    int generate(bool one_ns);
    int generate_functions(const std::string &filename);
    int dump_schemas(std::ostream &ostm) const;
    int generate_dot();
    int process_dtd(const std::string &filepath);

    void load_defaults();
    void load_osixaka1_defaults();
    void use_MFC_member_style();
    void generate_template(std::ostream &file);
    void save_preference(std::ostream &file);
    void load_preference(const std::string &filename);
    void set_instantiate_xiso_name(const std::string &instantiate_xiso_name);

    void commit_preference();

    // Preference-related methods.
    static void initialize();
    void reset();
    void set_basedir(const std::string &basedir);
    void set_outputdir(const std::string &outputdir);
  };
}

#endif
