/* -*- c++ -*- */
#ifndef XML_SCHEMA_ST_H__
#define XML_SCHEMA_ST_H__

namespace xs {
  typedef long allNNI;

  enum attribute_use {
    use_required,
    use_optional,
    use_prohibited
  };

  bool is_use_required(const xs::attribute_use &use);
  bool is_use_prohibited(const xs::attribute_use &use);
  bool is_use_optional(const xs::attribute_use &use);


  typedef short blockSet;

  enum blockSet_value {
    blockSet_none = 0,
    blockSet_all = 1,
    blockSet_extension = 2,
    blockSet_restriction = 4,
    blockSet_substitution = 8
  };

  typedef std::vector<std::string> namespaceList;

  typedef long all_minOccurs; /* minOccurs that allow 0, or 1. */
  typedef long all_maxOccurs; /* everytime should be 1 */

  enum formChoice {
    qualified = 0,
    unqualified
  };
  bool is_form_qualified(const formChoice &form);


  /** empty token is allowed, but @default not specified. */
  /* therefore specified as "osx:optional" attribute. */
  enum derivationSet_value {
    derivationSet_none = 0,
    derivationSet_extension = 1,
    derivationSet_restriction = 2
  };

  typedef long derivationSet;


}

#endif
