#include <osixaka2/serializer.h>
#include <akaxiso2/akaxiso2.h>

#include <osixaka2/xml_xiso.h>
#include <osixaka2/osx_xiso.h>
#include <osixaka2/XMLSchema_xiso.h>
void osx_instantiate_xiso() {
  aka::xmlns("osx", "http://akaxiso.sourceforge.jp/osixaka2/2.0-beta3");
  aka::doctype("osx:include", ::osx::include_leaf());
  aka::doctype("osx:namespace", ::osx::namespace_leaf());
  aka::doctype("osx:preference", ::osx::preference_leaf());
  aka::doctype("osx:ximpl_include", ::osx::include_leaf());
  aka::doctype("osx:xiso_include", ::osx::include_leaf());
  aka::xmlns("xs", "http://www.w3.org/2001/XMLSchema");
  aka::doctype("xs:all", ::xs::all_leaf());
  aka::doctype("xs:annotation", ::xs::annotation_leaf());
  aka::doctype("xs:any", ::xs::any_leaf());
  aka::doctype("xs:anyAttribute", ::xs::wildcard_leaf());
  aka::doctype("xs:appinfo", ::xs::appinfo_leaf());
  aka::doctype("xs:attribute", ::xs::topLevelAttribute_leaf());
  aka::doctype("xs:attributeGroup", ::xs::namedAttributeGroup_leaf());
  aka::doctype("xs:choice", ::xs::explicitGroup_leaf());
  aka::doctype("xs:complexContent", ::xs::complexContent_leaf());
  aka::doctype("xs:complexType", ::xs::topLevelComplexType_leaf());
  aka::doctype("xs:documentation", ::xs::documentation_leaf());
  aka::doctype("xs:element", ::xs::topLevelElement_leaf());
  aka::doctype("xs:enumeration", ::xs::noFixedFacet_leaf());
  aka::doctype("xs:field", ::xs::field_leaf());
  aka::doctype("xs:fractionDigits", ::xs::numFacet_leaf());
  aka::doctype("xs:group", ::xs::namedGroup_leaf());
  aka::doctype("xs:import", ::xs::import_leaf());
  aka::doctype("xs:include", ::xs::include_leaf());
  aka::doctype("xs:key", ::xs::keybase_leaf());
  aka::doctype("xs:keyref", ::xs::keyref_leaf());
  aka::doctype("xs:length", ::xs::numFacet_leaf());
  aka::doctype("xs:list", ::xs::list_leaf());
  aka::doctype("xs:maxExclusive", ::xs::facet_leaf());
  aka::doctype("xs:maxInclusive", ::xs::facet_leaf());
  aka::doctype("xs:maxLength", ::xs::numFacet_leaf());
  aka::doctype("xs:minExclusive", ::xs::facet_leaf());
  aka::doctype("xs:minInclusive", ::xs::facet_leaf());
  aka::doctype("xs:minLength", ::xs::numFacet_leaf());
  aka::doctype("xs:notation", ::xs::notation_leaf());
  aka::doctype("xs:pattern", ::xs::pattern_leaf());
  aka::doctype("xs:redefine", ::xs::redefine_leaf());
  aka::doctype("xs:restriction", ::xs::restriction_leaf());
  aka::doctype("xs:schema", ::xs::schema_leaf());
  aka::doctype("xs:selector", ::xs::selector_leaf());
  aka::doctype("xs:sequence", ::xs::explicitGroup_leaf());
  aka::doctype("xs:simpleContent", ::xs::simpleContent_leaf());
  aka::doctype("xs:simpleType", ::xs::topLevelSimpleType_leaf());
  aka::doctype("xs:totalDigits", ::xs::totalDigits_leaf());
  aka::doctype("xs:union", ::xs::union_leaf());
  aka::doctype("xs:unique", ::xs::keybase_leaf());
  aka::doctype("xs:whiteSpace", ::xs::whiteSpace_leaf());
}

void serialize(const ::osx::_namespace& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "osx:namespace", ostm);
}

void serialize(const ::osx::include& root, const std::string &tagname, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, tagname, ostm);
}

void serialize(const ::osx::preference& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "osx:preference", ostm);
}

void serialize(const ::xs::_union& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "xs:union", ostm);
}

void serialize(const ::xs::all& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "xs:all", ostm);
}

void serialize(const ::xs::annotation& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "xs:annotation", ostm);
}

void serialize(const ::xs::any& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "xs:any", ostm);
}

void serialize(const ::xs::appinfo& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "xs:appinfo", ostm);
}

void serialize(const ::xs::complexContent& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "xs:complexContent", ostm);
}

void serialize(const ::xs::documentation& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "xs:documentation", ostm);
}

void serialize(const ::xs::explicitGroup& root, const std::string &tagname, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, tagname, ostm);
}

void serialize(const ::xs::facet& root, const std::string &tagname, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, tagname, ostm);
}

void serialize(const ::xs::field& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "xs:field", ostm);
}

void serialize(const ::xs::import& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "xs:import", ostm);
}

void serialize(const ::xs::include& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "xs:include", ostm);
}

void serialize(const ::xs::keybase& root, const std::string &tagname, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, tagname, ostm);
}

void serialize(const ::xs::keyref& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "xs:keyref", ostm);
}

void serialize(const ::xs::list& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "xs:list", ostm);
}

void serialize(const ::xs::namedAttributeGroup& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "xs:attributeGroup", ostm);
}

void serialize(const ::xs::namedGroup& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "xs:group", ostm);
}

void serialize(const ::xs::noFixedFacet& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "xs:enumeration", ostm);
}

void serialize(const ::xs::notation& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "xs:notation", ostm);
}

void serialize(const ::xs::numFacet& root, const std::string &tagname, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, tagname, ostm);
}

void serialize(const ::xs::pattern& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "xs:pattern", ostm);
}

void serialize(const ::xs::redefine& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "xs:redefine", ostm);
}

void serialize(const ::xs::restriction& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "xs:restriction", ostm);
}

void serialize(const ::xs::schema& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "xs:schema", ostm);
}

void serialize(const ::xs::selector& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "xs:selector", ostm);
}

void serialize(const ::xs::simpleContent& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "xs:simpleContent", ostm);
}

void serialize(const ::xs::topLevelAttribute& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "xs:attribute", ostm);
}

void serialize(const ::xs::topLevelComplexType& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "xs:complexType", ostm);
}

void serialize(const ::xs::topLevelElement& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "xs:element", ostm);
}

void serialize(const ::xs::topLevelSimpleType& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "xs:simpleType", ostm);
}

void serialize(const ::xs::totalDigits& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "xs:totalDigits", ostm);
}

void serialize(const ::xs::whiteSpace& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "xs:whiteSpace", ostm);
}

void serialize(const ::xs::wildcard& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "xs:anyAttribute", ostm);
}


