#include <akaxiso2/akaxiso2.h>
#include <iostream>
#include <stdlib.h> /* {BCB6}:exit */

/** 
 *  sample.h generated by osixaka2 has decarations 
 *  for element classes and serialization functions.
 */
#include "sample.h"


int main(int argc, char* argv[]){
  
  // initialize akaxiso.
  aka::initialize();
  // initialize XML typeinfo classes.
  instantiate_xiso();

  // deserialize
  aka::document doc;
  try {
    doc = aka::deserialize(std::cin);
  }
  catch (const aka::error &e) {
    std::cerr << e.what() << std::endl;
    std::cerr << "Parse error detected.  Abort immediately." << std::endl;
    exit(1);
  }
  catch ( ... ) {
    std::cerr << "Unhandled parse error detected.  Abort immediatedly." << std::endl;
    exit(1);
  }

  /** If you would like to check the document tag name, use aka::document_of() like,
   * aka::document_of(doc, "xs:schema");
   */
  std::cerr << "Document name is " << doc.get_name() << "." << std::endl;

  /**
   * Get the root node of document, if you want to.
   * YourDoc *ydoc = aka::root_cast<YourDoc>(doc);
   *
   *  When aka::root_cast<> is used, obtained root node(xs:schema) is owned by doc 
   * instance in its shared pointer member.
   *  If you want to get ownership of root node instance, use aka::adopt_node<>() 
   * as shown in the following line, and you have to delete root node by yourself.
   *
   * xs::schema *schema = aka::adopt_root<xs::schema>(doc);
   */

  {
    aka::xml_serializer ser;
    ser.serialize(doc, std::cout);
  }
  // Uninitializers.
  aka::uninitialize();

  return 0;
}



