/* -*- c++ -*- */
#ifndef TEST_EXECUTOR_H__
#define TEST_EXECUTOR_H__

#include "test_result.h"

typedef std::vector<ts::testSet*> testSets;

class test_executor {
  test_results results_;
  testSets testSets_;

  static void mkdir_easy(const std::string &dirpath);
  static std::string dirname(const std::string &path);
  void do_check_schema_wellformedness(test_result *result);
  void do_validate_schema_deserialization(test_result *result);
  void do_validate_source_generation(test_result *result, const std::string &testdir);

public:
  void prepare();

  void set_testSuite(const ts::testSuite &testSuite, const std::string &testSuite_path);
  void set_testSet(const ts::testSet &testSet, const std::string &testSet_path);

  void check_files();
  void check_schema_wellformedness();

  void validate_schema_deserialization();
  void validate_source_generation();

  void write_error(outcome oc, std::ostream &ostm) const;
  void write_invalid_passes(std::ostream &ostm);

  int get_num_tests() const;
  int get_num_tests(outcome oc) const;

};


#endif
