// -*- c++ -*-
#ifndef AKAXISO2_XML_EXPAT_EXPAT_DOCUMENTHANDLER_H__
#define AKAXISO2_XML_EXPAT_EXPAT_DOCUMENTHANDLER_H__

#include <akaxiso2/configuration.h>
#ifdef AKAXISO2_USE_EXPAT

#include <akaxiso2/framework/document.h>
#include <akaxiso2/XML/deserializer/document_handler.h>
#include <akaxiso2/XML/deserializer/sax2_adaptor.h>
#include <akaxiso2/XML/expat/expat_parser.h>

namespace aka2 {

  class expat_handler : public expat_document_handler {
  public:
    expat_handler(entity_complements *ecomp);
    virtual ~expat_handler(){}
    
    void set_source_name(const std::string &source_name) {
      handler_.set_source_name(source_name);
    }
    void reset() { handler_.reset(); }
    
    virtual void startElement(const pstring &name, sax_attributes &saxattrs);
    virtual void endElement(const pstring &name);
    virtual void characters(const pchar_t *data, int len);

    document get_document();
    std::string encoding_;
  private:
    document_handler handler_;
    sax2_adaptor adaptor_;
  };

}

#endif

#endif

