/** -*- c++ -*- */
#ifndef AKAXISO2_XML_XERCES_TRANSCODING_INPUTSOURCE_H__
#define AKAXISO2_XML_XERCES_TRANSCODING_INPUTSOURCE_H__

/**
 * @file akaxiso2/XML/xerces/transcoding_inputsource.h
 */

#include <akaxiso2/configuration.h>
#ifdef AKAXISO2_USE_XERCESC

#include <xercesc/sax/InputSource.hpp>
#include <akaxiso2/util/iosfwd.h>
#include <akaxiso2/transcoders/stateful_transcoder.h>
#include <map>

namespace aka2 {

  class TranscodingInputSource : public xercesc::InputSource {
  public:
    TranscodingInputSource(const char *systemId,
			   const char *publicId,
			   transcoder_factory trfact);
    virtual ~TranscodingInputSource();

    // Must be reimplemented.
    // virtual xercesc::BinInputStream *makeStream() const;
    virtual void setup() = 0;
  protected:
    typedef std::map<std::string, stateful_transcoder*> transcoder_cache;
    bool setup_internal(const char *buffer, size_t length);
    stateful_transcoder *transcoder_; 
    transcoder_factory trfact_;
    transcoder_cache trcache_;
  };


  class BufferInputSource : public TranscodingInputSource {
  public:
    BufferInputSource(const char *systemId, 
		      const char *publicId,
		      transcoder_factory trfact,
		      const char *buffer, size_t length);
    virtual xercesc::BinInputStream *makeStream() const;
    virtual void setup();
  private:
    const char *buffer_;
    size_t length_;
  };


  class IStreamInputSource : public TranscodingInputSource {
  public:
    IStreamInputSource(const char *systemId,
		       const char *publicId,
		       transcoder_factory trfact,
		       std::istream &istm);
    virtual xercesc::BinInputStream *makeStream() const;
    virtual void setup();
  private:
    std::istream &istm_;
  };

} // namespace aka2


#endif /* AKAXISO2_USE_XERCESC */

#endif /* AKAXISO2_XML_XERCES_TRANSCODING_INPUTSOURCE_H__ */
