/* -*- c++ -*- */
#ifndef AKAXISO2_FRAMEWORK_BUILTIN_H__
#define AKAXISO2_FRAMEWORK_BUILTIN_H__

/**
 * @file akaxiso2/builtin/builtin.h
 * @brief akaxiso library builtin types and array types
 */

#include <akaxiso2/configuration.h>
#include <akaxiso2/util/platform.h>
#include <akaxiso2/util/deep_ptr.h>
#include <akaxiso2/framework/item.h>
#include <akaxiso2/framework/any.h>

#include <string>
#include <list>
#include <vector>

namespace aka2 {


  /**
     @code
     
     Here's the akaxiso's builtin types. 
     ------------------------------------------------------------
     Numeric types          min           max   XML-Schema type
     char                  -128           128   xs:byte
     unsigned char            0           255   xs:unsignedByte
     short               -32768         32767   xs:short   
     unsigned short           0         65535   xs:unsignedShort 
     long           -2147483648    2147483647   xs:int, xs:integer
     unsigned long            0        2^32-1   xs:unsignedInt,
     LONGLONG             -2^63        2^63-1   xs:long, 
     ULONGLONG                0        2^64-1   xs:unsignedLong,
     int                  compiler-dependent.   (Not mapped.)
     unsigned int         compiler-dependent.   (Not mapped.)
     ------------------------------------------------------------
     boolean type
     bool     true/false (0/1)     xs:boolean
     ------------------------------------------------------------
     floating-point number
     float
     double
     ------------------------------------------------------------
     string type.
     std::string
     ------------------------------------------------------------
     aka::nill  empty type.
     ------------------------------------------------------------
     @endcode
     
  */

  
  
  /* arrays for c++ builtins. */

  /** @brief array of c++'s char */
  typedef std::vector<char> char_array;
  /** @brief array of c++'s unsigned char */
  typedef std::vector<unsigned char> uchar_array;
  /** @brief array of c++'s unsigned short */
  typedef std::vector<short> short_array;
  /** @brief array of c++'s unsigned short */
  typedef std::vector<unsigned short> ushort_array;
  /** @brief array of c++'s long */
  typedef std::vector<long> long_array;
  /** @brief array of c++'s unsigned long */
  typedef std::vector<unsigned long> ulong_array;
  /** @brief array of 64-bit interger  */
  typedef std::vector<LONGLONG> longlong_array;
  /** @brief array of unsigned 64-bit interger */
  typedef std::vector<ULONGLONG> ulonglong_array;
  /** @brief array of c++'s int */
  typedef std::vector<int> int_array;
  /** @brief array of c++'s unsigned int */
  typedef std::vector<unsigned int> uint_array;
  /** @brief array of c++'s bool */
  typedef std::vector<bool> bool_array;
  /** @brief array of c++'s float */
  typedef std::vector<float> float_array;
  /** @brief array of c++'s double */
  typedef std::vector<double> double_array;
  /** @brief array of c++'s std::string */
  typedef std::vector<std::string> string_array;

  /**
   * @brief builin nill value class.
   *
   * This class is akaxiso2's builtin type to represent a class that does not have any value.\n
   * Use with aka2::nill_leaf.
   */
  struct nill {};

  /** @brief array of nill values. */
  typedef std::vector<nill> nill_array;

}


#endif
