#include "exception.h"
#include "util/sstream.h"
#include "util/string_funcs.h"

using namespace aka2;

error::error(const std::string &msg, const char *file, 
	     const unsigned long line) {
  std::ostringstream ostm;
  ostm << msg << '(' << file << ':' << line << ')';
  msg_ = ostm.rdbuf()->str();
}


error::~error() throw() {
}

const char *error::what() const throw() {
  return msg_.c_str();
}

positioned_error::positioned_error(const std::string &msg, 
				   const char *file, 
				   const unsigned long file_line,
				   const std::string &path,
				   const std::string &source,
				   long line,
				   long column)
  : error(msg, file, file_line), source_(source), path_(path), line_(line), column_(column) { }

positioned_error::positioned_error(const error &e) {
  msg_ = e.what();
}

positioned_error::positioned_error(const positioned_error &e) {
  msg_ = e.msg_;
  path_ = e.path_;
  source_ = e.source_;
  line_ = e.line_;
  column_ = e.column_;
}


positioned_error::~positioned_error() throw() {
}

void positioned_error::set_position(const std::string &source, long line, long column) {
  source_ = source;
  line_ = line;
  column_ = column;
}

const char *positioned_error::what() const throw() {
  std::ostringstream ostm;
  ostm << source_ << ':' << line_ << ':' << column_;
  if (!path_.empty())
    ostm << ":PATH=" << quote(path_);
  ostm << ' ' << msg_;
  positioned_msg_ = ostm.str();
  return positioned_msg_.c_str();
}


tagged_error::tagged_error(const std::string &caption, 
			   const std::string &tagname,
			   const std::string &msg, 
			   const char *file, const unsigned long line) {
  std::ostringstream ostm;
  ostm << caption + " \"" + tagname + "\":" + msg << " (" << file << ':' << line << ')';
  msg_ = ostm.rdbuf()->str();
}

tagged_error::~tagged_error() throw() {
}
