/* -*- c++ -*- */
#ifndef AKAXISO2_FRAMEWORK_ALL_H__
#define AKAXISO2_FRAMEWORK_ALL_H__

/**
 * @file akaxiso2/framework/all.h
 * @brief @ref aka_all -related classes/templates
 */

#include <akaxiso2/framework/simpletype.h>
#include <akaxiso2/framework/attribute.h>
#include <akaxiso2/framework/memberdef.h>

namespace aka2 {

  template<class L>
  class all_op_dispatcher : public all_op {
  public:
    virtual schematype_id get_schematype() const { return all_id; }
    virtual const qname &get_typename() const { return L::get_xmltype(); }
    /** creatable */
    virtual void construct(void *e) const {  L::construct(e); }
    virtual void copy_construct(void *e, const void *src) const { L::copy_construct(e, src); }
    virtual void destruct(void *e) const { L::destruct(e); }
    virtual size_t class_size() const { return L::class_size(); }
    virtual bool equals(const void *lhs, const void *rhs) const {
      return L::equals(lhs, rhs);
    }

    /** attribute_info getter. */
    virtual const attribute_types *get_attribute_types() const {
      return &L::attribute_types_;
    }
    virtual const attribute_type *get_anyattr_type() const { return L::get_anyattr_type(); }
    /** all_info getter. */
    virtual const member_types &get_member_types() const {
      return L::member_types_;
    }
  };


  template<class L>
  struct all_statics {
    static member_types member_types_;
    static all_op_dispatcher<L> dispatcher_;
  };

  template<class L>
  member_types all_statics<L>::member_types_;

  template<class L>
  all_op_dispatcher<L> all_statics<L>::dispatcher_;

  
  /**
   * @brief template to define @ref aka_all leaf class.
   *
   * Leaf classes for @ref aka_all are derived from this template class.\n
   * Most of Member-defining classes/functions are implemented in aka2::memberdef<L, T>.\n
   *
   * @param T value class type
   * @param L leaf class type
   */
  template<class T, class L=xiso::leaf<T> >
  class all : public all_statics<L>, 
	      public attributes<L, T>,
	      public memberdef<L, T> {
  public:
    typedef T value_type;
    
    virtual ~all(){}
    
    static member_type* register_membertype(const member_type &mtype) {
      bool res = L::member_types_.add(mtype);
      if (!res)
	throw tagged_error("element", mtype.get_name().qualified(), "declared twice.",
			   __FILE__, __LINE__);
      return &L::member_types_.back();
    }
    
    static void initialize() {
      if (!system_type_registry().add(L()))
      	return;
      L::member_types_.clear();
      L::attribute_types_.clear();
      L l; l.model(); // VC6 does not accept L().model();
      check_emptiable(L::member_types_);
      L::member_types_.make_sorted_cache();
      L::attribute_types_.make_sorted_cache();
    }

    static void uninitialize() {
      L::member_types_.clear();
      L::attribute_types_.clear();
    }

    static void construct(void *e) {
      new (e) T();
      all_construct(e, L::dispatcher_);
    }
    static void copy_construct(void *e, const void *src) {
      new (e) T(*static_cast<const T*>(src));
    }
    static size_t class_size() { return sizeof(T); }
    static void destruct(void *elm) { static_cast<T*>(elm)->~T(); }

    static bool equals(const void *lhs, const void *rhs) {
      return all_equals(lhs, rhs, L::dispatcher_);
    }

    static element_op* get_attribute_dispatcher() { return &L::dispatcher_; }
    static default_op* create_default_op() { return 0; }
  };

} // namespace aka2

#endif
