#include "entity_complements.h"
#include "namespace_statics.h"
#include "namespaces.h"
#include "../util/string_funcs.h"
#include "../transcoders/encoding_name.h"

namespace aka2 {
  extern aka2::entity_complements *g_ecomp_;
}

using namespace aka2;

void aka2::reset_for_new_document() {
  g_ecomp_->reset_for_new_document();
}

entity_complements::~entity_complements() {
  if (transcoder_)
    delete transcoder_;
  clear_complements();
}


entity_complements::entity_complements(transcoder_factory tf) {
  trfact_ = tf;
}

entity_complements* entity_complements::create(transcoder_factory tf) {
  entity_complements *ret = new entity_complements(tf);
  ret->prefixes_ = shared_ptr<prefix_map>(new prefix_map());
  ret->transcoder_ = pivot_transcoder::create(tf);
  return ret; 
}

entity_complements* entity_complements::clone(entity_complements &ecomps,
					      bool clone_prefixes, 
					      transcoder_factory tf) {
  entity_complements *ret = new entity_complements(tf);
  if (clone_prefixes)
    ret->prefixes_ = shared_ptr<prefix_map>(new prefix_map(*ecomps.prefixes_));
  else
    ret->prefixes_ = shared_ptr<prefix_map>(new prefix_map());
  ret->transcoder_ = pivot_transcoder::create(tf);
  return ret; 
}

void entity_complements::clear_all() {
  if (prefixes_ != 0)
    prefixes_->clear();
  id_constraint_.clear();
  clear_complements();
}

void entity_complements::reset_for_new_document() {
  id_constraint_.clear();
  for (complements::iterator it = complements_.begin();
       it != complements_.end(); ++it) {
    entity_complement &con = it->second;
    con.reset_for_new_document();
  }
}


void entity_complements::add_complement_ptr(const std::string &name, 
					    void *p, 
					    complement_operator *prop_op) {
  entity_complement ecom(p, prop_op);
  std::pair<complements::iterator, bool> res = 
    complements_.insert(complements::value_type(name, ecom));
  if (!res.second)
    throw error("Precondition complement " + quote(name) + " is already added.",
		__FILE__, __LINE__);
}

void *entity_complements::get_complement_ptr(const std::string &name) const {
  complements::const_iterator it = complements_.find(name);
  if (it == complements_.end())
    throw error("Complement " + quote(name) + " not found.", __FILE__, __LINE__);
  return it->second.complement_;
}

const void *entity_complements::const_get_complement_ptr(const std::string &name) const {
  return get_complement_ptr(name);
}

void entity_complements::clear_complements() {
  complements_.clear();
}

bool entity_complements::check_id(const std::string &value) {
  if (id_constraint_.find(value) != id_constraint_.end())
    return false;
  const_cast<entity_complements*>(this)->id_constraint_.insert(value);
  return true;
}
