/* -*- c++ -*- */
#ifndef AKAXISO2_UNICODE_USTRING_H__
#define AKAXISO2_UNICODE_USTRING_H__

/**
 * @file akaxiso2/unicode/ustring.h
 * @brief UCS2 string class.
 */

/** 
 * @class aka2::ustring
 * @brief cross-platform version of std::basic_string<> for UCS2.
 *
 * For WIN32 environment, aka2::ustring is a typedef name of std::wstring.<br>
 * For gcc envirrnment, std::string is for UCS4, therefore std::basic_string<aka2::uchar_t> is 
 * typedef'ed as aka2::ustring.
 */

/**
 * @typedef aka2::uchar_t
 * @brief UCS2 character typedef for cross-platform environment. 
 * 
 * For WIN32 environment, uchar_t is a typedef name of wchar_t.<br>
 * For gcc environment, wchar_t is for UCS4, therefore unsigned short is typedef'ed 
 * as aka::uchar_t.
 */

#include <akaxiso2/configuration.h>
#include <string>

namespace aka2 {
#if defined(AKAXISO2_USE_OWN_USTRING)
  typedef unsigned short uchar_t;

  /**
   * for g++-3.X,
   * std::basic_string<uchar_t, std::char_traits<uchar_t> > 
   * For g++-2.96.
   * std::basic_string<uchar_t, std::string_char_traits<uchar_t> >
   */
  typedef std::basic_string<aka2::uchar_t> ustring;

#else
  typedef wchar_t uchar_t;
  typedef std::basic_string<wchar_t> ustring;
#endif
}

#endif
