#include <osixaka2/XMLSchema_xiso.h>



#include <akaxiso2/akaxiso2.h>


namespace xs {

  void appinfo_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:appinfo");
    /** element member definitions */
    any("&any", &::xs::appinfo::any_, 0, aka::unbounded, "##any");
    /** attribute member definition. */
    attribute("source", &::xs::appinfo::source_, xs::anyURI_leaf());
    any_attribute(&::xs::appinfo::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void documentation_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:documentation");
    /** element member definitions */
    any("&any", &::xs::documentation::any_, 0, aka::unbounded, "##any");
    /** attribute member definition. */
    attribute("source", &::xs::documentation::source_, xs::anyURI_leaf());
    attribute("xml:lang", &::xs::documentation::xml_lang_, xs::language_leaf());
    any_attribute(&::xs::documentation::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void annotation_choice_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:annotation_choice");
    /** occurrence used when choice is a root element. */
    occurrence(0, aka::unbounded);
    /** element member definitions */
    item("xs:appinfo", ::xs::appinfo_leaf());
    item("xs:documentation", ::xs::documentation_leaf());
  }

  void annotation_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:annotation");
    /** element member definitions */
    member("&c0", &::xs::annotation::c0_, ::xs::annotation_choice_leaf(), 0, aka::unbounded);
    /** attribute member definition. */
    attribute("id", &::xs::annotation::id_, xs::ID_leaf());
    any_attribute(&::xs::annotation::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void annotated_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:annotated");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::annotated::annotation_, ::xs::annotation_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::annotated::id_, xs::ID_leaf());
    any_attribute(&::xs::annotated::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void any_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:any");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::any::annotation_, ::xs::annotation_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::any::id_, xs::ID_leaf());
    attribute("namespace", &::xs::any::namespace_, xs::namespaceList_leaf()).set_default("##any");
    attribute("processContents", &::xs::any::processContents_, xs::NMTOKEN_leaf()).set_default("strict");
    attribute("minOccurs", &::xs::any::minOccurs_, xs::nonNegativeInteger_leaf()).set_default("1");
    attribute("maxOccurs", &::xs::any::maxOccurs_, xs::allNNI_leaf()).set_default("1");
    any_attribute(&::xs::any::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void anyType_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:anyType");
    /** element member definitions */
    any("&any", &::xs::anyType::any_, 0, aka::unbounded, "##any");
    /** attribute member definition. */
    any_attribute(&::xs::anyType::attributes_, "##any");
  }

  void attributeGroupRef_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:attributeGroupRef");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::attributeGroupRef::annotation_, ::xs::annotation_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::attributeGroupRef::id_, xs::ID_leaf());
    attribute("ref", &::xs::attributeGroupRef::ref_, xs::QName_leaf()).required(true);
    any_attribute(&::xs::attributeGroupRef::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void groupRef_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:groupRef");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::groupRef::annotation_, ::xs::annotation_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::groupRef::id_, xs::ID_leaf());
    attribute("ref", &::xs::groupRef::ref_, xs::QName_leaf()).required(true);
    attribute("minOccurs", &::xs::groupRef::minOccurs_, xs::nonNegativeInteger_leaf()).set_default("1");
    attribute("maxOccurs", &::xs::groupRef::maxOccurs_, xs::allNNI_leaf()).set_default("1");
    any_attribute(&::xs::groupRef::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void facet_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:facet");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::facet::annotation_, ::xs::annotation_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::facet::id_, xs::ID_leaf());
    attribute("value", &::xs::facet::value_, xiso::leaf< ::std::string>()).required(true);
    attribute("fixed", &::xs::facet::fixed_, xs::boolean_leaf()).set_default("false");
    any_attribute(&::xs::facet::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void field_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:field");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::field::annotation_, ::xs::annotation_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::field::id_, xs::ID_leaf());
    attribute("xpath", &::xs::field::xpath_, xs::token_leaf()).required(true);
    any_attribute(&::xs::field::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void import_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:import");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::import::annotation_, ::xs::annotation_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::import::id_, xs::ID_leaf());
    attribute("namespace", &::xs::import::namespace_, xs::anyURI_leaf());
    attribute("schemaLocation", &::xs::import::schemaLocation_, xs::anyURI_leaf());
    any_attribute(&::xs::import::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void include_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:include");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::include::annotation_, ::xs::annotation_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::include::id_, xs::ID_leaf());
    attribute("schemaLocation", &::xs::include::schemaLocation_, xs::anyURI_leaf()).required(true);
    any_attribute(&::xs::include::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void selector_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:selector");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::selector::annotation_, ::xs::annotation_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::selector::id_, xs::ID_leaf());
    attribute("xpath", &::xs::selector::xpath_, xs::token_leaf()).required(true);
    any_attribute(&::xs::selector::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void keybase_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:keybase");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::keybase::annotation_, ::xs::annotation_leaf());
    member("xs:selector", &::xs::keybase::selector_, ::xs::selector_leaf());
    member("xs:field", &::xs::keybase::field_, ::xs::field_array_leaf(), 1, aka::unbounded);
    /** attribute member definition. */
    attribute("id", &::xs::keybase::id_, xs::ID_leaf());
    attribute("name", &::xs::keybase::name_, xs::NCName_leaf()).required(true);
    any_attribute(&::xs::keybase::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void keyref_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:keyref");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::keyref::annotation_, ::xs::annotation_leaf());
    member("xs:selector", &::xs::keyref::selector_, ::xs::selector_leaf());
    member("xs:field", &::xs::keyref::field_, ::xs::field_array_leaf(), 1, aka::unbounded);
    /** attribute member definition. */
    attribute("id", &::xs::keyref::id_, xs::ID_leaf());
    attribute("name", &::xs::keyref::name_, xs::NCName_leaf()).required(true);
    attribute("refer", &::xs::keyref::refer_, xs::QName_leaf()).required(true);
    any_attribute(&::xs::keyref::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void noFixedFacet_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:noFixedFacet");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::noFixedFacet::annotation_, ::xs::annotation_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::noFixedFacet::id_, xs::ID_leaf());
    attribute("value", &::xs::noFixedFacet::value_, xiso::leaf< ::std::string>()).required(true);
    any_attribute(&::xs::noFixedFacet::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void notation_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:notation");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::notation::annotation_, ::xs::annotation_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::notation::id_, xs::ID_leaf());
    attribute("name", &::xs::notation::name_, xs::NCName_leaf()).required(true);
    attribute("public", &::xs::notation::public_, xs::token_leaf());
    attribute("system", &::xs::notation::system_, xs::anyURI_leaf());
    any_attribute(&::xs::notation::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void numFacet_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:numFacet");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::numFacet::annotation_, ::xs::annotation_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::numFacet::id_, xs::ID_leaf());
    attribute("value", &::xs::numFacet::value_, xs::nonNegativeInteger_leaf()).required(true);
    attribute("fixed", &::xs::numFacet::fixed_, xs::boolean_leaf()).set_default("false");
    any_attribute(&::xs::numFacet::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void openAttrs_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:openAttrs");
    /** attribute member definition. */
    any_attribute(&::xs::openAttrs::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void pattern_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:pattern");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::pattern::annotation_, ::xs::annotation_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::pattern::id_, xs::ID_leaf());
    attribute("value", &::xs::pattern::value_, xs::string_leaf()).required(true);
    any_attribute(&::xs::pattern::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void totalDigits_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:totalDigits");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::totalDigits::annotation_, ::xs::annotation_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::totalDigits::id_, xs::ID_leaf());
    attribute("value", &::xs::totalDigits::value_, xs::positiveInteger_leaf()).required(true);
    attribute("fixed", &::xs::totalDigits::fixed_, xs::boolean_leaf()).set_default("false");
    any_attribute(&::xs::totalDigits::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void whiteSpace_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:whiteSpace");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::whiteSpace::annotation_, ::xs::annotation_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::whiteSpace::id_, xs::ID_leaf());
    attribute("value", &::xs::whiteSpace::value_, xs::NMTOKEN_leaf()).required(true);
    attribute("fixed", &::xs::whiteSpace::fixed_, xs::boolean_leaf()).set_default("false");
    any_attribute(&::xs::whiteSpace::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void wildcard_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:wildcard");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::wildcard::annotation_, ::xs::annotation_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::wildcard::id_, xs::ID_leaf());
    attribute("namespace", &::xs::wildcard::namespace_, xs::namespaceList_leaf()).set_default("##any");
    attribute("processContents", &::xs::wildcard::processContents_, xs::NMTOKEN_leaf()).set_default("strict");
    any_attribute(&::xs::wildcard::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void facets_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:facets");
    /** occurrence used when choice is a root element. */
    occurrence(1, 1);
    /** element member definitions */
    item("xs:minExclusive", ::xs::facet_leaf());
    item("xs:minInclusive", ::xs::facet_leaf());
    item("xs:maxExclusive", ::xs::facet_leaf());
    item("xs:maxInclusive", ::xs::facet_leaf());
    item("xs:totalDigits", ::xs::totalDigits_leaf());
    item("xs:fractionDigits", ::xs::numFacet_leaf());
    item("xs:length", ::xs::numFacet_leaf());
    item("xs:minLength", ::xs::numFacet_leaf());
    item("xs:maxLength", ::xs::numFacet_leaf());
    item("xs:enumeration", ::xs::noFixedFacet_leaf());
    item("xs:whiteSpace", ::xs::whiteSpace_leaf());
    item("xs:pattern", ::xs::pattern_leaf());
  }

  void identityConstraint_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:identityConstraint");
    /** occurrence used when choice is a root element. */
    occurrence(1, 1);
    /** element member definitions */
    item("xs:unique", ::xs::keybase_leaf());
    item("xs:key", ::xs::keybase_leaf());
    item("xs:keyref", ::xs::keyref_leaf());
  }

  void topLevelElement_sequence_c0_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:topLevelElement_sequence_c0");
    /** occurrence used when choice is a root element. */
    occurrence(0, 1);
    /** element member definitions */
    item("xs:simpleType", ::xs::localSimpleType_leaf());
    item("xs:complexType", ::xs::localComplexType_leaf());
  }

  void topLevelElement_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:topLevelElement");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::topLevelElement::annotation_, ::xs::annotation_leaf());
    member("&c0", &::xs::topLevelElement::c0_, ::xs::topLevelElement_sequence_c0_leaf(), 0, 1);
    member("&identityConstraint", &::xs::topLevelElement::identityConstraint_, ::xs::identityConstraint_leaf(), 0, aka::unbounded);
    /** attribute member definition. */
    attribute("id", &::xs::topLevelElement::id_, xs::ID_leaf());
    attribute("name", &::xs::topLevelElement::name_, xs::NCName_leaf()).required(true);
    attribute("type", &::xs::topLevelElement::type_, xs::QName_leaf());
    attribute("substitutionGroup", &::xs::topLevelElement::substitutionGroup_, xs::QName_leaf());
    attribute("default", &::xs::topLevelElement::default_, xs::string_leaf());
    attribute("fixed", &::xs::topLevelElement::fixed_, xs::string_leaf());
    attribute("nillable", &::xs::topLevelElement::nillable_, xs::boolean_leaf()).set_default("false");
    attribute("abstract", &::xs::topLevelElement::abstract_, xs::boolean_leaf()).set_default("false");
    ptrattribute("final", &::xs::topLevelElement::final_, xs::derivationSet_leaf());
    ptrattribute("block", &::xs::topLevelElement::block_, xs::blockSet_leaf());
    any_attribute(&::xs::topLevelElement::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void directives_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:schema_sequence_c0");
    /** occurrence used when choice is a root element. */
    occurrence(0, aka::unbounded);
    /** element member definitions */
    item("xs:include", ::xs::include_leaf());
    item("xs:import", ::xs::import_leaf());
    item("xs:redefine", ::xs::redefine_leaf());
    item("xs:annotation", ::xs::annotation_leaf());
  }

  void schemaTop_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:schemaTop");
    /** occurrence used when choice is a root element. */
    occurrence(1, 1);
    /** element member definitions */
    item("&redefinable", ::xs::redefinable_leaf());
    item("xs:element", ::xs::topLevelElement_leaf());
    item("xs:attribute", ::xs::topLevelAttribute_leaf());
    item("xs:notation", ::xs::notation_leaf());
  }

  void schemaTops_item_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:schema_sequence_s0_item");
    /** element member definitions */
    member("&schemaTop", &::xs::schemaTops_item::schemaTop_, ::xs::schemaTop_leaf());
    member("xs:annotation", &::xs::schemaTops_item::annotation_, ::xs::annotation_array_leaf(), 0, aka::unbounded);
  }

  void schema_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:schema");
    /** element member definitions */
    member("&directives", &::xs::schema::directives_, ::xs::directives_leaf(), 0, aka::unbounded);
    member("&schemaTops", &::xs::schema::schemaTops_, ::xs::schemaTops_leaf(), 0, aka::unbounded);
    /** attribute member definition. */
    attribute("targetNamespace", &::xs::schema::targetNamespace_, xs::anyURI_leaf());
    attribute("version", &::xs::schema::version_, xs::token_leaf());
    attribute("finalDefault", &::xs::schema::finalDefault_, xiso::leaf< ::std::string>());
    attribute("blockDefault", &::xs::schema::blockDefault_, xs::blockSet_leaf());
    attribute("attributeFormDefault", &::xs::schema::attributeFormDefault_, xs::formChoice_leaf()).set_default("unqualified");
    attribute("elementFormDefault", &::xs::schema::elementFormDefault_, xs::formChoice_leaf()).set_default("unqualified");
    attribute("id", &::xs::schema::id_, xs::ID_leaf());
    attribute("xml:lang", &::xs::schema::xml_lang_, xs::language_leaf());
    any_attribute(&::xs::schema::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void restrictionType_sequence_c0_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:restrictionType_sequence_c0");
    /** occurrence used when choice is a root element. */
    occurrence(0, 1);
    /** element member definitions */
    item("&typeDefParticle", ::xs::typeDefParticle_leaf());
    item("&simpleRestrictionModel", ::xs::simpleRestrictionModel_leaf());
  }

  void redefine_choice_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:redefine_choice");
    /** occurrence used when choice is a root element. */
    occurrence(0, aka::unbounded);
    /** element member definitions */
    item("xs:annotation", ::xs::annotation_leaf());
    item("&redefinable", ::xs::redefinable_leaf());
  }

  void redefine_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:redefine");
    /** element member definitions */
    member("&c0", &::xs::redefine::c0_, ::xs::redefine_choice_leaf(), 0, aka::unbounded);
    /** attribute member definition. */
    attribute("schemaLocation", &::xs::redefine::schemaLocation_, xs::anyURI_leaf()).required(true);
    attribute("id", &::xs::redefine::id_, xs::ID_leaf());
    any_attribute(&::xs::redefine::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void realGroup_sequence_c0_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:realGroup_sequence_c0");
    /** occurrence used when choice is a root element. */
    occurrence(0, 1);
    /** element member definitions */
    item("xs:all", ::xs::all_leaf());
    item("xs:choice", ::xs::explicitGroup_leaf());
    item("xs:sequence", ::xs::explicitGroup_leaf());
  }

  void realGroup_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:realGroup");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::realGroup::annotation_, ::xs::annotation_leaf());
    member("&c0", &::xs::realGroup::c0_, ::xs::realGroup_sequence_c0_leaf(), 0, 1);
    /** attribute member definition. */
    attribute("id", &::xs::realGroup::id_, xs::ID_leaf());
    attribute("name", &::xs::realGroup::name_, xs::NCName_leaf());
    attribute("ref", &::xs::realGroup::ref_, xs::QName_leaf());
    attribute("minOccurs", &::xs::realGroup::minOccurs_, xs::nonNegativeInteger_leaf()).set_default("1");
    attribute("maxOccurs", &::xs::realGroup::maxOccurs_, xs::allNNI_leaf()).set_default("1");
    attribute("osx:classname", &::xs::realGroup::osx_classname_, xs::token_leaf());
    any_attribute(&::xs::realGroup::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void namedGroup_sequence_c0_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:namedGroup_sequence_c0");
    /** occurrence used when choice is a root element. */
    occurrence(1, 1);
    /** element member definitions */
    item("xs:all", ::xs::namedGroup_sequence_c0_all_leaf());
    item("xs:choice", ::xs::simpleExplicitGroup_leaf());
    item("xs:sequence", ::xs::simpleExplicitGroup_leaf());
  }

  void namedGroup_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:namedGroup");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::namedGroup::annotation_, ::xs::annotation_leaf());
    member("&c0", &::xs::namedGroup::c0_, ::xs::namedGroup_sequence_c0_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::namedGroup::id_, xs::ID_leaf());
    attribute("name", &::xs::namedGroup::name_, xs::NCName_leaf()).required(true);
    attribute("osx:classname", &::xs::namedGroup::osx_classname_, xs::token_leaf());
    any_attribute(&::xs::namedGroup::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void localElement_sequence_c0_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:localElement_sequence_c0");
    /** occurrence used when choice is a root element. */
    occurrence(0, 1);
    /** element member definitions */
    item("xs:simpleType", ::xs::localSimpleType_leaf());
    item("xs:complexType", ::xs::localComplexType_leaf());
  }

  void localElement_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:localElement");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::localElement::annotation_, ::xs::annotation_leaf());
    member("&c0", &::xs::localElement::c0_, ::xs::localElement_sequence_c0_leaf(), 0, 1);
    member("&identityConstraint", &::xs::localElement::identityConstraint_, ::xs::identityConstraint_leaf(), 0, aka::unbounded);
    /** attribute member definition. */
    attribute("id", &::xs::localElement::id_, xs::ID_leaf());
    attribute("name", &::xs::localElement::name_, xs::NCName_leaf());
    attribute("ref", &::xs::localElement::ref_, xs::QName_leaf());
    attribute("type", &::xs::localElement::type_, xs::QName_leaf());
    attribute("minOccurs", &::xs::localElement::minOccurs_, xs::nonNegativeInteger_leaf()).set_default("1");
    attribute("maxOccurs", &::xs::localElement::maxOccurs_, xs::allNNI_leaf()).set_default("1");
    attribute("default", &::xs::localElement::default_, xs::string_leaf());
    attribute("fixed", &::xs::localElement::fixed_, xs::string_leaf());
    attribute("nillable", &::xs::localElement::nillable_, xs::boolean_leaf()).set_default("false");
    ptrattribute("block", &::xs::localElement::block_, xs::blockSet_leaf());
    ptrattribute("form", &::xs::localElement::form_, xs::formChoice_leaf());
    any_attribute(&::xs::localElement::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void element_sequence_c0_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:element_sequence_c0");
    /** occurrence used when choice is a root element. */
    occurrence(0, 1);
    /** element member definitions */
    item("xs:simpleType", ::xs::localSimpleType_leaf());
    item("xs:complexType", ::xs::localComplexType_leaf());
  }

  void element_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:element");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::element::annotation_, ::xs::annotation_leaf());
    member("&c0", &::xs::element::c0_, ::xs::element_sequence_c0_leaf(), 0, 1);
    member("&identityConstraint", &::xs::element::identityConstraint_, ::xs::identityConstraint_leaf(), 0, aka::unbounded);
    /** attribute member definition. */
    attribute("id", &::xs::element::id_, xs::ID_leaf());
    attribute("name", &::xs::element::name_, xs::NCName_leaf());
    attribute("ref", &::xs::element::ref_, xs::QName_leaf());
    attribute("type", &::xs::element::type_, xs::QName_leaf());
    attribute("substitutionGroup", &::xs::element::substitutionGroup_, xs::QName_leaf());
    attribute("minOccurs", &::xs::element::minOccurs_, xs::nonNegativeInteger_leaf()).set_default("1");
    attribute("maxOccurs", &::xs::element::maxOccurs_, xs::allNNI_leaf()).set_default("1");
    attribute("default", &::xs::element::default_, xs::string_leaf());
    attribute("fixed", &::xs::element::fixed_, xs::string_leaf());
    attribute("nillable", &::xs::element::nillable_, xs::boolean_leaf()).set_default("false");
    attribute("abstract", &::xs::element::abstract_, xs::boolean_leaf()).set_default("false");
    ptrattribute("final", &::xs::element::final_, xs::derivationSet_leaf());
    ptrattribute("block", &::xs::element::block_, xs::blockSet_leaf());
    ptrattribute("form", &::xs::element::form_, xs::formChoice_leaf());
    any_attribute(&::xs::element::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void simpleContent_choice_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:simpleContent_choice");
    /** occurrence used when choice is a root element. */
    occurrence(1, 1);
    /** element member definitions */
    item("xs:restriction", ::xs::simpleRestrictionType_leaf());
    item("xs:extension", ::xs::simpleExtensionType_leaf());
  }

  void simpleContent_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:simpleContent");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::simpleContent::annotation_, ::xs::annotation_leaf());
    member("&c0", &::xs::simpleContent::c0_, ::xs::simpleContent_choice_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::simpleContent::id_, xs::ID_leaf());
    any_attribute(&::xs::simpleContent::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void complexContent_choice_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:complexContent_choice");
    /** occurrence used when choice is a root element. */
    occurrence(1, 1);
    /** element member definitions */
    item("xs:restriction", ::xs::complexRestrictionType_leaf());
    item("xs:extension", ::xs::extensionType_leaf());
  }

  void complexContent_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:complexContent");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::complexContent::annotation_, ::xs::annotation_leaf());
    member("&c0", &::xs::complexContent::c0_, ::xs::complexContent_choice_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::complexContent::id_, xs::ID_leaf());
    attribute("mixed", &::xs::complexContent::mixed_, xs::boolean_leaf());
    any_attribute(&::xs::complexContent::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void typeDefParticle_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:typeDefParticle");
    /** occurrence used when choice is a root element. */
    occurrence(1, 1);
    /** element member definitions */
    item("xs:group", ::xs::groupRef_leaf());
    item("xs:all", ::xs::all_leaf());
    item("xs:choice", ::xs::explicitGroup_leaf());
    item("xs:sequence", ::xs::explicitGroup_leaf());
  }

  void attrDecls_c0_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:attrDecls_c0");
    /** occurrence used when choice is a root element. */
    occurrence(0, aka::unbounded);
    /** element member definitions */
    item("xs:attribute", ::xs::attribute_leaf());
    item("xs:attributeGroup", ::xs::attributeGroupRef_leaf());
  }

  void attrDecls_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:attrDecls");
    /** element member definitions */
    member("&c0", &::xs::attrDecls::c0_, ::xs::attrDecls_c0_leaf(), 0, aka::unbounded);
    ptrmember("xs:anyAttribute", &::xs::attrDecls::anyAttribute_, ::xs::wildcard_leaf());
  }

  void complexTypeModelParticle_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:complexTypeModel_s0");
    /** element member definitions */
    member("&typeDefParticle", &::xs::complexTypeModelParticle::typeDefParticle_, ::xs::typeDefParticle_leaf(), 0, 1);
    member("&attrDecls", &::xs::complexTypeModelParticle::attrDecls_, ::xs::attrDecls_leaf());
  }

  void attributeGroup_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:attributeGroup");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::attributeGroup::annotation_, ::xs::annotation_leaf());
    member("&attrDecls", &::xs::attributeGroup::attrDecls_, ::xs::attrDecls_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::attributeGroup::id_, xs::ID_leaf());
    attribute("name", &::xs::attributeGroup::name_, xs::NCName_leaf());
    attribute("ref", &::xs::attributeGroup::ref_, xs::QName_leaf());
    any_attribute(&::xs::attributeGroup::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void complexRestrictionType_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:complexRestrictionType");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::complexRestrictionType::annotation_, ::xs::annotation_leaf());
    member("&typeDefParticle", &::xs::complexRestrictionType::typeDefParticle_, ::xs::typeDefParticle_leaf(), 0, 1);
    member("&attrDecls", &::xs::complexRestrictionType::attrDecls_, ::xs::attrDecls_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::complexRestrictionType::id_, xs::ID_leaf());
    attribute("base", &::xs::complexRestrictionType::base_, xs::QName_leaf()).required(true);
    any_attribute(&::xs::complexRestrictionType::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void complexTypeModel_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:complexTypeModel");
    /** occurrence used when choice is a root element. */
    occurrence(1, 1);
    /** element member definitions */
    item("xs:simpleContent", ::xs::simpleContent_leaf());
    item("xs:complexContent", ::xs::complexContent_leaf());
    item("&complexTypeModelParticle", ::xs::complexTypeModelParticle_leaf());
  }

  void complexType_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:complexType");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::complexType::annotation_, ::xs::annotation_leaf());
    member("&complexTypeModel", &::xs::complexType::complexTypeModel_, ::xs::complexTypeModel_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::complexType::id_, xs::ID_leaf());
    attribute("name", &::xs::complexType::name_, xs::NCName_leaf());
    attribute("mixed", &::xs::complexType::mixed_, xs::boolean_leaf()).set_default("false");
    attribute("osx:classname", &::xs::complexType::osx_classname_, xs::token_leaf());
    attribute("abstract", &::xs::complexType::abstract_, xs::boolean_leaf()).set_default("false");
    ptrattribute("final", &::xs::complexType::final_, xs::derivationSet_leaf());
    ptrattribute("block", &::xs::complexType::block_, xs::derivationSet_leaf());
    any_attribute(&::xs::complexType::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void extensionType_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:extensionType");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::extensionType::annotation_, ::xs::annotation_leaf());
    member("&typeDefParticle", &::xs::extensionType::typeDefParticle_, ::xs::typeDefParticle_leaf(), 0, 1);
    member("&attrDecls", &::xs::extensionType::attrDecls_, ::xs::attrDecls_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::extensionType::id_, xs::ID_leaf());
    attribute("base", &::xs::extensionType::base_, xs::QName_leaf()).required(true);
    any_attribute(&::xs::extensionType::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void localComplexType_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:localComplexType");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::localComplexType::annotation_, ::xs::annotation_leaf());
    member("&complexTypeModel", &::xs::localComplexType::complexTypeModel_, ::xs::complexTypeModel_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::localComplexType::id_, xs::ID_leaf());
    attribute("mixed", &::xs::localComplexType::mixed_, xs::boolean_leaf()).set_default("false");
    attribute("osx:classname", &::xs::localComplexType::osx_classname_, xs::token_leaf());
    any_attribute(&::xs::localComplexType::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void namedAttributeGroup_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:namedAttributeGroup");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::namedAttributeGroup::annotation_, ::xs::annotation_leaf());
    member("&attrDecls", &::xs::namedAttributeGroup::attrDecls_, ::xs::attrDecls_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::namedAttributeGroup::id_, xs::ID_leaf());
    attribute("name", &::xs::namedAttributeGroup::name_, xs::NCName_leaf()).required(true);
    any_attribute(&::xs::namedAttributeGroup::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void restrictionType_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:restrictionType");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::restrictionType::annotation_, ::xs::annotation_leaf());
    member("&c0", &::xs::restrictionType::c0_, ::xs::restrictionType_sequence_c0_leaf(), 0, 1);
    member("&attrDecls", &::xs::restrictionType::attrDecls_, ::xs::attrDecls_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::restrictionType::id_, xs::ID_leaf());
    attribute("base", &::xs::restrictionType::base_, xs::QName_leaf()).required(true);
    any_attribute(&::xs::restrictionType::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void simpleExtensionType_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:simpleExtensionType");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::simpleExtensionType::annotation_, ::xs::annotation_leaf());
    member("&attrDecls", &::xs::simpleExtensionType::attrDecls_, ::xs::attrDecls_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::simpleExtensionType::id_, xs::ID_leaf());
    attribute("base", &::xs::simpleExtensionType::base_, xs::QName_leaf()).required(true);
    any_attribute(&::xs::simpleExtensionType::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void topLevelComplexType_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:topLevelComplexType");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::topLevelComplexType::annotation_, ::xs::annotation_leaf());
    member("&complexTypeModel", &::xs::topLevelComplexType::complexTypeModel_, ::xs::complexTypeModel_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::topLevelComplexType::id_, xs::ID_leaf());
    attribute("name", &::xs::topLevelComplexType::name_, xs::NCName_leaf()).required(true);
    attribute("mixed", &::xs::topLevelComplexType::mixed_, xs::boolean_leaf()).set_default("false");
    attribute("osx:classname", &::xs::topLevelComplexType::osx_classname_, xs::token_leaf());
    attribute("abstract", &::xs::topLevelComplexType::abstract_, xs::boolean_leaf()).set_default("false");
    ptrattribute("final", &::xs::topLevelComplexType::final_, xs::derivationSet_leaf());
    ptrattribute("block", &::xs::topLevelComplexType::block_, xs::derivationSet_leaf());
    any_attribute(&::xs::topLevelComplexType::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void narrowMaxMin_sequence_c0_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:narrowMaxMin_sequence_c0");
    /** occurrence used when choice is a root element. */
    occurrence(0, 1);
    /** element member definitions */
    item("xs:simpleType", ::xs::localSimpleType_leaf());
    item("xs:complexType", ::xs::localComplexType_leaf());
  }

  void narrowMaxMin_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:narrowMaxMin");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::narrowMaxMin::annotation_, ::xs::annotation_leaf());
    member("&c0", &::xs::narrowMaxMin::c0_, ::xs::narrowMaxMin_sequence_c0_leaf(), 0, 1);
    member("&identityConstraint", &::xs::narrowMaxMin::identityConstraint_, ::xs::identityConstraint_leaf(), 0, aka::unbounded);
    /** attribute member definition. */
    attribute("id", &::xs::narrowMaxMin::id_, xs::ID_leaf());
    attribute("name", &::xs::narrowMaxMin::name_, xs::NCName_leaf());
    attribute("ref", &::xs::narrowMaxMin::ref_, xs::QName_leaf());
    attribute("type", &::xs::narrowMaxMin::type_, xs::QName_leaf());
    attribute("minOccurs", &::xs::narrowMaxMin::minOccurs_, xs::nonNegativeInteger_leaf()).set_default("1");
    attribute("maxOccurs", &::xs::narrowMaxMin::maxOccurs_, xs::allNNI_leaf()).set_default("1");
    attribute("default", &::xs::narrowMaxMin::default_, xs::string_leaf());
    attribute("fixed", &::xs::narrowMaxMin::fixed_, xs::string_leaf());
    attribute("nillable", &::xs::narrowMaxMin::nillable_, xs::boolean_leaf()).set_default("false");
    ptrattribute("block", &::xs::narrowMaxMin::block_, xs::blockSet_leaf());
    ptrattribute("form", &::xs::narrowMaxMin::form_, xs::formChoice_leaf());
    any_attribute(&::xs::narrowMaxMin::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void allModel_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:allModel");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::allModel::annotation_, ::xs::annotation_leaf());
    member("xs:element", &::xs::allModel::element_, ::xs::narrowMaxMin_array_leaf(), 0, aka::unbounded);
  }

  void namedGroup_sequence_c0_all_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:namedGroup_sequence_c0_all");
    /** element member definitions */
    member("&allModel", &::xs::namedGroup_sequence_c0_all::allModel_, ::xs::allModel_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::namedGroup_sequence_c0_all::id_, xs::ID_leaf());
    attribute("osx:classname", &::xs::namedGroup_sequence_c0_all::osx_classname_, xs::token_leaf());
    any_attribute(&::xs::namedGroup_sequence_c0_all::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void all_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:all");
    /** element member definitions */
    member("&allModel", &::xs::all::allModel_, ::xs::allModel_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::all::id_, xs::ID_leaf());
    attribute("minOccurs", &::xs::all::minOccurs_, xs::all_minOccurs_leaf()).set_default("1");
    attribute("maxOccurs", &::xs::all::maxOccurs_, xs::all_maxOccurs_leaf()).set_default("1");
    attribute("osx:classname", &::xs::all::osx_classname_, xs::token_leaf());
    any_attribute(&::xs::all::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void attribute_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:attribute");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::attribute::annotation_, ::xs::annotation_leaf());
    ptrmember("xs:simpleType", &::xs::attribute::simpleType_, ::xs::localSimpleType_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::attribute::id_, xs::ID_leaf());
    attribute("name", &::xs::attribute::name_, xs::NCName_leaf());
    attribute("ref", &::xs::attribute::ref_, xs::QName_leaf());
    attribute("type", &::xs::attribute::type_, xs::QName_leaf());
    attribute("use", &::xs::attribute::use_, xs::attribute_use_leaf()).set_default("optional");
    attribute("default", &::xs::attribute::default_, xs::string_leaf());
    attribute("fixed", &::xs::attribute::fixed_, xs::string_leaf());
    ptrattribute("form", &::xs::attribute::form_, xs::formChoice_leaf());
    attribute("osx:presence", &::xs::attribute::osx_presence_, xs::NCName_leaf());
    any_attribute(&::xs::attribute::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void nestedParticle_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:nestedParticle");
    /** occurrence used when choice is a root element. */
    occurrence(1, 1);
    /** element member definitions */
    item("xs:element", ::xs::localElement_leaf());
    item("xs:group", ::xs::groupRef_leaf());
    item("xs:choice", ::xs::explicitGroup_leaf());
    item("xs:sequence", ::xs::explicitGroup_leaf());
    item("xs:any", ::xs::any_leaf());
  }

  void explicitGroup_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:explicitGroup");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::explicitGroup::annotation_, ::xs::annotation_leaf());
    member("&nestedParticle", &::xs::explicitGroup::nestedParticle_, ::xs::nestedParticle_leaf(), 0, aka::unbounded);
    /** attribute member definition. */
    attribute("id", &::xs::explicitGroup::id_, xs::ID_leaf());
    attribute("minOccurs", &::xs::explicitGroup::minOccurs_, xs::nonNegativeInteger_leaf()).set_default("1");
    attribute("maxOccurs", &::xs::explicitGroup::maxOccurs_, xs::allNNI_leaf()).set_default("1");
    attribute("osx:classname", &::xs::explicitGroup::osx_classname_, xs::token_leaf());
    any_attribute(&::xs::explicitGroup::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void particle_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:particle");
    /** occurrence used when choice is a root element. */
    occurrence(1, 1);
    /** element member definitions */
    item("xs:element", ::xs::localElement_leaf());
    item("xs:group", ::xs::groupRef_leaf());
    item("xs:all", ::xs::all_leaf());
    item("xs:choice", ::xs::explicitGroup_leaf());
    item("xs:sequence", ::xs::explicitGroup_leaf());
    item("xs:any", ::xs::any_leaf());
  }

  void group_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:group");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::group::annotation_, ::xs::annotation_leaf());
    member("&particle", &::xs::group::particle_, ::xs::particle_leaf(), 0, aka::unbounded);
    /** attribute member definition. */
    attribute("id", &::xs::group::id_, xs::ID_leaf());
    attribute("name", &::xs::group::name_, xs::NCName_leaf());
    attribute("ref", &::xs::group::ref_, xs::QName_leaf());
    attribute("minOccurs", &::xs::group::minOccurs_, xs::nonNegativeInteger_leaf()).set_default("1");
    attribute("maxOccurs", &::xs::group::maxOccurs_, xs::allNNI_leaf()).set_default("1");
    attribute("osx:classname", &::xs::group::osx_classname_, xs::token_leaf());
    any_attribute(&::xs::group::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void simpleExplicitGroup_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:simpleExplicitGroup");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::simpleExplicitGroup::annotation_, ::xs::annotation_leaf());
    member("&nestedParticle", &::xs::simpleExplicitGroup::nestedParticle_, ::xs::nestedParticle_leaf(), 0, aka::unbounded);
    /** attribute member definition. */
    attribute("id", &::xs::simpleExplicitGroup::id_, xs::ID_leaf());
    attribute("osx:classname", &::xs::simpleExplicitGroup::osx_classname_, xs::token_leaf());
    any_attribute(&::xs::simpleExplicitGroup::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void list_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:list");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::list::annotation_, ::xs::annotation_leaf());
    ptrmember("xs:simpleType", &::xs::list::simpleType_, ::xs::localSimpleType_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::list::id_, xs::ID_leaf());
    attribute("itemType", &::xs::list::itemType_, xs::QName_leaf());
    any_attribute(&::xs::list::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void simpleDerivation_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:simpleDerivation");
    /** occurrence used when choice is a root element. */
    occurrence(1, 1);
    /** element member definitions */
    item("xs:restriction", ::xs::restriction_leaf());
    item("xs:list", ::xs::list_leaf());
    item("xs:union", ::xs::union_leaf());
  }

  void localSimpleType_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:localSimpleType");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::localSimpleType::annotation_, ::xs::annotation_leaf());
    member("&simpleDerivation", &::xs::localSimpleType::simpleDerivation_, ::xs::simpleDerivation_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::localSimpleType::id_, xs::ID_leaf());
    attribute("osx:leaf", &::xs::localSimpleType::osx_leaf_, xs::token_leaf());
    attribute("osx:typedef_of", &::xs::localSimpleType::osx_typedef_of_, xs::token_leaf());
    attribute("osx:resolve", &::xs::localSimpleType::osx_resolve_, xs::QName_leaf());
    attribute("osx:classname", &::xs::localSimpleType::osx_classname_, xs::token_leaf());
    any_attribute(&::xs::localSimpleType::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void simpleRestrictionModel_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:simpleRestrictionModel");
    /** element member definitions */
    ptrmember("xs:simpleType", &::xs::simpleRestrictionModel::simpleType_, ::xs::localSimpleType_leaf());
    member("&facets", &::xs::simpleRestrictionModel::facets_, ::xs::facets_leaf(), 0, aka::unbounded);
  }

  void restriction_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:restriction");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::restriction::annotation_, ::xs::annotation_leaf());
    member("&simpleRestrictionModel", &::xs::restriction::simpleRestrictionModel_, ::xs::simpleRestrictionModel_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::restriction::id_, xs::ID_leaf());
    attribute("base", &::xs::restriction::base_, xs::QName_leaf());
    any_attribute(&::xs::restriction::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void simpleRestrictionType_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:simpleRestrictionType");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::simpleRestrictionType::annotation_, ::xs::annotation_leaf());
    ptrmember("&simpleRestrictionModel", &::xs::simpleRestrictionType::simpleRestrictionModel_, ::xs::simpleRestrictionModel_leaf());
    member("&attrDecls", &::xs::simpleRestrictionType::attrDecls_, ::xs::attrDecls_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::simpleRestrictionType::id_, xs::ID_leaf());
    attribute("base", &::xs::simpleRestrictionType::base_, xs::QName_leaf()).required(true);
    any_attribute(&::xs::simpleRestrictionType::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void simpleType_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:simpleType");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::simpleType::annotation_, ::xs::annotation_leaf());
    member("&simpleDerivation", &::xs::simpleType::simpleDerivation_, ::xs::simpleDerivation_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::simpleType::id_, xs::ID_leaf());
    attribute("final", &::xs::simpleType::final_, xiso::leaf< ::std::string>());
    attribute("name", &::xs::simpleType::name_, xs::NCName_leaf());
    attribute("osx:leaf", &::xs::simpleType::osx_leaf_, xs::token_leaf());
    attribute("osx:typedef_of", &::xs::simpleType::osx_typedef_of_, xs::token_leaf());
    attribute("osx:resolve", &::xs::simpleType::osx_resolve_, xs::QName_leaf());
    attribute("osx:classname", &::xs::simpleType::osx_classname_, xs::token_leaf());
    any_attribute(&::xs::simpleType::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void topLevelAttribute_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:topLevelAttribute");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::topLevelAttribute::annotation_, ::xs::annotation_leaf());
    ptrmember("xs:simpleType", &::xs::topLevelAttribute::simpleType_, ::xs::localSimpleType_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::topLevelAttribute::id_, xs::ID_leaf());
    attribute("name", &::xs::topLevelAttribute::name_, xs::NCName_leaf()).required(true);
    attribute("type", &::xs::topLevelAttribute::type_, xs::QName_leaf());
    attribute("default", &::xs::topLevelAttribute::default_, xs::string_leaf());
    attribute("fixed", &::xs::topLevelAttribute::fixed_, xs::string_leaf());
    any_attribute(&::xs::topLevelAttribute::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void topLevelSimpleType_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:topLevelSimpleType");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::topLevelSimpleType::annotation_, ::xs::annotation_leaf());
    member("&simpleDerivation", &::xs::topLevelSimpleType::simpleDerivation_, ::xs::simpleDerivation_leaf());
    /** attribute member definition. */
    attribute("id", &::xs::topLevelSimpleType::id_, xs::ID_leaf());
    attribute("final", &::xs::topLevelSimpleType::final_, xiso::leaf< ::std::string>());
    attribute("name", &::xs::topLevelSimpleType::name_, xs::NCName_leaf()).required(true);
    attribute("osx:leaf", &::xs::topLevelSimpleType::osx_leaf_, xs::token_leaf());
    attribute("osx:typedef_of", &::xs::topLevelSimpleType::osx_typedef_of_, xs::token_leaf());
    attribute("osx:resolve", &::xs::topLevelSimpleType::osx_resolve_, xs::QName_leaf());
    attribute("osx:classname", &::xs::topLevelSimpleType::osx_classname_, xs::token_leaf());
    any_attribute(&::xs::topLevelSimpleType::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void union_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:union");
    /** element member definitions */
    ptrmember("xs:annotation", &::xs::_union::annotation_, ::xs::annotation_leaf());
    member("xs:simpleType", &::xs::_union::simpleType_, ::xs::localSimpleType_array_leaf(), 0, aka::unbounded);
    /** attribute member definition. */
    attribute("id", &::xs::_union::id_, xs::ID_leaf());
    attribute("memberTypes", &::xs::_union::memberTypes_, xiso::leaf< ::std::string>());
    any_attribute(&::xs::_union::attributes_, "##other:http://www.w3.org/2001/XMLSchema");
  }

  void redefinable_leaf::model() {
    /** XML-Schema type name. */
    xmltype("xs:redefinable");
    /** occurrence used when choice is a root element. */
    occurrence(1, 1);
    /** element member definitions */
    item("xs:simpleType", ::xs::topLevelSimpleType_leaf());
    item("xs:complexType", ::xs::topLevelComplexType_leaf());
    item("xs:group", ::xs::namedGroup_leaf());
    item("xs:attributeGroup", ::xs::namedAttributeGroup_leaf());
  }


}

