#include "cpp_namer.h"

using namespace osx;


aka::qname cpp_namer::rename(const type_ref &type) const {

  if (type.is_imported()) {
    const imported_type *imported = type.imported_;
    if (imported->import_id_ == import_intrinsic)
      return imported->get_name();
  }

  aka::qname renamed = type.get_classname();

  const substitution_array &substitutions = pref_.substitutions_.substitution_;
  for (substitution_array::const_iterator sit = substitutions.begin(); 
       sit != substitutions.end(); ++sit) {
    if (renamed.local() == sit->original_) {
      renamed = aka::qname(renamed.get_namespace_id(),
			   sit->substituted_);
      break;
    }
  }
  return renamed;
}

std::string cpp_namer::resolve_typedef(const type_ref &type) {
  // Don't have to consider array, because array could not be a root type.

  if (registry_.is_aka_any(type.get_name()))
    return cppname(type.get_name());
  
  type_ref resolved = registry_.resolve_typedef(type);
  if (resolved.is_imported()) {
    const imported_type *imported = resolved.imported_;
    if (!imported->typedef_of_.empty())
      return imported->typedef_of_;
  }
  return classname(type);
}


std::string cpp_namer::leafname(const type_ref &type) const {
  
  type_ref resolved = registry_.resolve_type(type);
  if (resolved.is_imported()) {
    const imported_type *imported = resolved.imported_;
    if (!imported->leaf_.empty())
      return imported->leaf_; 
  }
  else {
    const user_class *us = type.us_;
    aka::qname leaftype;
    if (!us->get_leaf_type().empty())
      leaftype = us->get_leaf_type();
    else {
      leaftype = aka::qname(us->get_classname().get_namespace_id(),
			    us->get_classname().local() + "_leaf");
    }
    return cppname(leaftype);
  }
  return "xiso::leaf< " + classname(type) + ">";
}


std::string cpp_namer::leaftype(const type_ref &type) const {

  assert(!type.is_imported());
  const user_class *us = type.us_;

  aka::qname leaftype = us->get_leaf_type();
  if (leaftype.empty()) {
    leaftype = aka::qname(us->get_classname().get_namespace_id(),
			  us->get_classname().local() + "_leaf");
  }
  if (!leaftype.empty())
    return escape(leaftype.local());

  assert(!"Must not reach here.");
  return std::string();
}

std::string cpp_namer::escape(const std::string &to_escape) const {
  std::string escaped = to_escape;
  
  escape_array::const_iterator it;
  const escape_array &escapes = pref_.escapes_.escape_;
  for (it = escapes.begin(); it != escapes.end(); ++it) {
    bool replaced;
    do {
      replaced = false;
      std::string::size_type pos = escaped.find(it->to_escape_);
      if (pos != std::string::npos) {
	std::string::size_type len = std::string(it->to_escape_).size();
	escaped = escaped.substr(0, pos) + it->escaped_ + 
	  escaped.substr(pos + len);
	replaced = true;
      }
    } while (replaced);
  } 
  return escaped;
}


const std::string &cpp_namer::choice_container_type() const {
  return pref_.format_.choice_.container_;
}

const std::string &cpp_namer::array_container_type() const {
  return pref_.format_.array_.container_;
}

const std::string &cpp_namer::simplecontent_value_name() const {
  return pref_.format_.simplecontent_.valuename_;
}

const std::string &cpp_namer::get_member_prefix() const {
  return pref_.format_.member_.prefix_;
}

const std::string &cpp_namer::get_member_suffix() const {
  return pref_.format_.member_.suffix_;
}

const std::string &cpp_namer::get_array_prefix() const {
  return pref_.format_.array_.prefix_;
}

const std::string &cpp_namer::get_array_suffix() const {
  return pref_.format_.array_.suffix_;
}

std::string cpp_namer::classname(const type_ref &type) const {

  type_ref resolved = registry_.resolve_type(type);

  if (resolved.is_imported()) { 
    const imported_type *imported = resolved.imported_;
    if (imported->import_id_ == import_intrinsic) {
      aka::qname resolved = imported->get_classname();
      if (resolved.prefix().empty())
	return resolved.local();
      else
	return "::" + resolved.prefix() + "::" + resolved.local();
    }
    else if (imported->import_id_ == import_weak_resolve) {
      assert(!imported->typedef_of_.empty());
      return imported->typedef_of_;
    }
  }

  aka::qname renamed = rename(type);
  return cppname(renamed);
}

std::string cpp_namer::cppname(const aka::qname &name) const {
  std::string to_escape;
  if (name.prefix().empty())
    to_escape = "::" + name.local();
  else
    to_escape = "::" + name.prefix() + "::" + name.local();
  return escape(to_escape);
}

std::string cpp_namer::classtype(const type_ref &type) const {
  aka::qname renamed = rename(type);
  return escape(renamed.local());
}
